#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "gpc_app.h"

#include "gpc_options.h"
#include "gpc_options_intf.h"

#include "support.h"


void
on_gpc_options_dialog_realize          (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "repository_combo_entry")), gnome_config_get_string ("/gphotocoll/options/repository"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "hidden_files_checkbutton")), gpc_get_hidden_files);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "confirm_inserts_checkbutton")), gpc_confirm_insert_refs);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "store_password_checkbutton")), gpc_store_password);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "auto_connect_checkbutton")), gpc_auto_connect);
  switch (gpc_zoom_mode) {
    case GPC_ZOOM_CURRENT      : gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "actual_zoom_radiobutton")), TRUE);
                                 break;
    case GPC_ZOOM_NORMAL       : gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "normal_zoom_radiobutton")), TRUE);
                                 break;
    case GPC_ZOOM_FIT          : gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "fit_zoom_radiobutton")), TRUE);
                                 break;
    case GPC_ZOOM_FIT_IF_LARGE : gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "fit_if_large_zoom_radiobutton")), TRUE);
                                 break;
    default                    : break;
  }
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (lookup_widget (widget, "thumbnails_size_spinbutton")), gnome_config_get_int ("/gphotocoll/thumbnails/size=100"));
  gnome_font_picker_set_font_name (GNOME_FONT_PICKER (lookup_widget (widget, "thumbnails_font_picker")), gnome_config_get_string ("/gphotocoll/thumbnails/font=-adobe-helvetica-medium-r-normal-*-*-100-*-*-p-*-iso8859-1"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "store_thumbnails_checkbutton")), gpc_store_thumbnails);
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "thumbnails_convert_entry")), gnome_config_get_string ("/gphotocoll/thumbnails/convert=convert -geometry \"150x150>\" -enhance \"%s\" \"%s\""));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (widget, "delete_references_checkbutton")), gpc_delete_removed_files);
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "acquisition_command_entry")), gnome_config_get_string ("/gphotocoll/tools/acquisition_command=xsane"));
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "acquisition_params_entry")), gnome_config_get_string ("/gphotocoll/tools/acquisition_params"));
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "gimp_command_entry")), gnome_config_get_string ("/gphotocoll/tools/gimp_command=gimp"));
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "gimp_params_entry")), gnome_config_get_string ("/gphotocoll/tools/gimp_params=%s"));
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "ee_command_entry")), gnome_config_get_string ("/gphotocoll/tools/ee_command=eeyes"));
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (widget, "ee_params_entry")), gnome_config_get_string ("/gphotocoll/tools/ee_params=%s"));
  gnome_property_box_set_state (GNOME_PROPERTY_BOX (gpc_options_dialog), FALSE);
}


void
on_gpc_options_dialog_apply            (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data)
{
  if (gpc_repository)
    g_free (gpc_repository);
  gpc_repository = gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "repository_combo_entry")), 0, -1);
  gnome_config_set_string ("/gphotocoll/options/repository", gpc_repository);
  gpc_confirm_insert_refs = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "confirm_inserts_checkbutton")));
  gpc_delete_removed_files = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "delete_references_checkbutton")));
  gpc_store_thumbnails = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "store_thumbnails_checkbutton")));
  gpc_store_password = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "store_password_checkbutton")));
  gpc_auto_connect = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "auto_connect_checkbutton")));
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "actual_zoom_radiobutton"))))
    gpc_zoom_mode = GPC_ZOOM_CURRENT;
  else
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "normal_zoom_radiobutton"))))
    gpc_zoom_mode = GPC_ZOOM_NORMAL;
  else
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "fit_zoom_radiobutton"))))
    gpc_zoom_mode = GPC_ZOOM_FIT;
  else
    gpc_zoom_mode = GPC_ZOOM_FIT_IF_LARGE;
  gnome_config_set_int ("/gphotocoll/thumbnails/size", gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (lookup_widget (gpc_options_dialog, "thumbnails_size_spinbutton"))));
  gnome_config_set_string ("/gphotocoll/thumbnails/font", gnome_font_picker_get_font_name (GNOME_FONT_PICKER (lookup_widget (gpc_options_dialog, "thumbnails_font_picker"))));
  gnome_config_set_string ("/gphotocoll/thumbnails/convert", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "thumbnails_convert_entry")), 0, -1));
  gpc_get_hidden_files = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "hidden_files_checkbutton")));
  gnome_config_set_string ("/gphotocoll/tools/acquisition_command", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "acquisition_command_entry")), 0, -1));
  gnome_config_set_string ("/gphotocoll/tools/acquisition_params", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "acquisition_params_entry")), 0, -1));
  gnome_config_set_string ("/gphotocoll/tools/gimp_command", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "gimp_command_entry")), 0, -1));
  gnome_config_set_string ("/gphotocoll/tools/gimp_params", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "gimp_params_entry")), 0, -1));
  gnome_config_set_string ("/gphotocoll/tools/ee_command", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "ee_command_entry")), 0, -1));
  gnome_config_set_string ("/gphotocoll/tools/ee_params", gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_options_dialog, "ee_params_entry")), 0, -1));
  gnome_config_sync ();
}


void
on_boolean_property_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_options_dialog));
}


void
on_text_property_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_options_dialog));
}


void
on_store_password_checkbutton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  gboolean test;
  
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_options_dialog));
  test = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (togglebutton));
  if (!test)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_options_dialog, "auto_connect_checkbutton")), FALSE);
  gtk_widget_set_sensitive (lookup_widget (gpc_options_dialog, "auto_connect_checkbutton"), test);
}

void
on_int_property_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_options_dialog));
}


void
on_font_property_changed               (GnomeFontPicker *gnomefontpicker,
                                        gchar           *arg1,
                                        gpointer         user_data)
{
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_options_dialog));
}

