/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 0.2.4 - March 2000
 *
 */

/*
 * Misc Functions
 */

#include <time.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <math.h>
#include <string.h>
#include "misc.h"
#include "spectrum.h"
#include "main_screen.h"
#include "globals.h"
#include "server.h"
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "text.h"
#include "phasescope.h"

int OPTnew;

gint				/* Will be called when we click on the spectrum */
  spectrum_motion_event (GtkWidget * widget, GdkEventMotion * event)
{				// Click on the spectrum
  int x;
  float newfreq;
  x = (int) event->x;
  newfreq = spectrum_new_fc (x);
  commControl (COMM_RXCH, COMM_FREQ, (int) (100 * newfreq));
  return 0;
}

gint display_time (gpointer data)	/* Displays the UTC-Date */
{
  char *c;
  c = get_time_string (NULL);
  gtk_statusbar_pop (GTK_STATUSBAR (statusbar.time), 1);
  gtk_statusbar_push (GTK_STATUSBAR (statusbar.time), 1, c);
  g_free (c);
  return TRUE;
}

/*
 * This function returns a pointer to the time string
 * YOU MUST FREE it
 */


gchar *
get_time_string (gchar * format)
{
  static char *c = NULL;

  time_t calendar_time;
  struct tm *my_time;
  char time_string[50];
  int i = 0;
  calendar_time = time (0);
  my_time = gmtime (&calendar_time);
  if (format == NULL)
    strftime (time_string, 50, "%a, %d %b %H:%M:%Sz %Y", my_time);
  else
    strftime (time_string, 50, format, my_time);
  return g_strdup (time_string);
}

/*
 * This function parses the configuration file
 */

void
read_config ()
{
  int i;
  int fd;
  char *home = getenv ("HOME");
  char conf[strlen (home) + 60];
  strcpy (conf, home);
  strcat (conf, "/.gpsk31/gpsk31.conf");
  fd = open (conf, O_RDONLY);
  if (fd == -1)
    fd = open (DATADIR "/gpsk31.conf", O_RDONLY);
  if (fd == -1)
    g_error ("Unable to open configuration file!");
  GScanner *scanner = g_scanner_new (NULL);
  char string0[16][40];
  char string1[16][40];
  scanner->config->numbers_2_int = TRUE;
  scanner->config->symbol_2_token = TRUE;


  enum
  { SYMBOL_TX_WINDOW_COLOR = G_TOKEN_LAST + 1,
    SYMBOL_RX_WINDOW_COLOR_RX = G_TOKEN_LAST + 2,
    SYMBOL_RX_WINDOW_COLOR_TX = G_TOKEN_LAST + 3,
    SYMBOL_TX_WINDOW_FONT = G_TOKEN_LAST + 4,
    SYMBOL_RX_WINDOW_FONT = G_TOKEN_LAST + 5,
    SYMBOL_PHASE_SCOPE_DCD_ON_COLOR = G_TOKEN_LAST + 6,
    SYMBOL_PHASE_SCOPE_DCD_OFF_COLOR = G_TOKEN_LAST + 7,
    SYMBOL_PHASE_SCOPE_ARC_COLOR = G_TOKEN_LAST + 8,
    SYMBOL_SPECTRUM_COLOR = G_TOKEN_LAST + 9,
    SYMBOL_SPECTRUM_TUNE_LINE_COLOR = G_TOKEN_LAST + 10,
    SYMBOL_CALLSIGN = G_TOKEN_LAST + 11,
    SYMBOL_NAME = G_TOKEN_LAST + 12,
    SYMBOL_QTH = G_TOKEN_LAST + 13,
    SYMBOL_CW_STRING = G_TOKEN_LAST + 14,
    SYMBOL_FREQ = G_TOKEN_LAST + 15,
    SYMBOL_DCD_LEVEL = G_TOKEN_LAST + 16,
    SYMBOL_LSB = G_TOKEN_LAST + 17,
    SYMBOL_PTT_DEVICE = G_TOKEN_LAST + 18,
    SYMBOL_AUDIO_DEVICE = G_TOKEN_LAST + 19,
    SYMBOL_NEW_RX = G_TOKEN_LAST + 20,
    SYMBOL_SPECTRUM_WIDTH = G_TOKEN_LAST + 21,
    SYMBOL_SPECTRUM_SPEED = G_TOKEN_LAST + 22,
    SYMBOL_FIRST_FIX = G_TOKEN_LAST + 23
  };

  g_scanner_freeze_symbol_table (scanner);
  g_scanner_add_symbol (scanner, "tx_window_color",
			GINT_TO_POINTER (SYMBOL_TX_WINDOW_COLOR));
  g_scanner_add_symbol (scanner, "rx_window_color_rx",
			GINT_TO_POINTER (SYMBOL_RX_WINDOW_COLOR_RX));
  g_scanner_add_symbol (scanner, "rx_window_color_tx",
			GINT_TO_POINTER (SYMBOL_RX_WINDOW_COLOR_TX));
  g_scanner_add_symbol (scanner, "tx_window_font",
			GINT_TO_POINTER (SYMBOL_TX_WINDOW_FONT));
  g_scanner_add_symbol (scanner, "rx_window_font",
			GINT_TO_POINTER (SYMBOL_RX_WINDOW_FONT));
  g_scanner_add_symbol (scanner, "phase_scope_dcd_on_color",
			GINT_TO_POINTER (SYMBOL_PHASE_SCOPE_DCD_ON_COLOR));
  g_scanner_add_symbol (scanner, "phase_scope_dcd_off_color",
			GINT_TO_POINTER (SYMBOL_PHASE_SCOPE_DCD_OFF_COLOR));
  g_scanner_add_symbol (scanner, "phase_scope_arc_color",
			GINT_TO_POINTER (SYMBOL_PHASE_SCOPE_ARC_COLOR));
  g_scanner_add_symbol (scanner, "spectrum_color",
			GINT_TO_POINTER (SYMBOL_SPECTRUM_COLOR));
  g_scanner_add_symbol (scanner, "spectrum_tune_line_color",
			GINT_TO_POINTER (SYMBOL_SPECTRUM_TUNE_LINE_COLOR));
  g_scanner_add_symbol (scanner, "callsign",
			GINT_TO_POINTER (SYMBOL_CALLSIGN));
  g_scanner_add_symbol (scanner, "name", GINT_TO_POINTER (SYMBOL_NAME));
  g_scanner_add_symbol (scanner, "qth", GINT_TO_POINTER (SYMBOL_QTH));
  g_scanner_add_symbol (scanner, "cw_string",
			GINT_TO_POINTER (SYMBOL_CW_STRING));
  g_scanner_add_symbol (scanner, "freq", GINT_TO_POINTER (SYMBOL_FREQ));
  g_scanner_add_symbol (scanner, "dcd_level",
			GINT_TO_POINTER (SYMBOL_DCD_LEVEL));
  g_scanner_add_symbol (scanner, "lsb", GINT_TO_POINTER (SYMBOL_LSB));
  g_scanner_add_symbol (scanner, "ptt_device",
			GINT_TO_POINTER (SYMBOL_PTT_DEVICE));
  g_scanner_add_symbol (scanner, "audio_device",
			GINT_TO_POINTER (SYMBOL_AUDIO_DEVICE));
  g_scanner_add_symbol (scanner, "new_rx", GINT_TO_POINTER (SYMBOL_NEW_RX));
  g_scanner_add_symbol (scanner, "spectrum_width",
			GINT_TO_POINTER (SYMBOL_SPECTRUM_WIDTH));
  g_scanner_add_symbol (scanner, "spectrum_speed",
			GINT_TO_POINTER (SYMBOL_SPECTRUM_SPEED));

  for (i = SYMBOL_FIRST_FIX; i <= SYMBOL_FIRST_FIX + 30; i = i + 2)
    {
      sprintf (string0[(i - SYMBOL_FIRST_FIX) / 2], "label%d",
	       (i - SYMBOL_FIRST_FIX) / 2);
      g_scanner_add_symbol (scanner, string0[(i - SYMBOL_FIRST_FIX) / 2],
			    GINT_TO_POINTER (i));
      sprintf (string1[(i - SYMBOL_FIRST_FIX) / 2], "text%d",
	       (i - SYMBOL_FIRST_FIX) / 2);
      g_scanner_add_symbol (scanner, string1[(i - SYMBOL_FIRST_FIX) / 2],
			    GINT_TO_POINTER (i + 1));
    }

  g_scanner_thaw_symbol_table (scanner);
  g_scanner_input_file (scanner, fd);

  /* tx_window_color */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_TX_WINDOW_COLOR)
    g_error ("gpsk31.conf:%d `tx_window_color' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.tx_window_color, scanner->value.v_string);

  /* rx_window_color_rx */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_RX_WINDOW_COLOR_RX)
    g_error ("gpsk31.conf:%d `rx_window_color_rx' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.rx_window_color_rx, scanner->value.v_string);

  /* rx_window_color_tx */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_RX_WINDOW_COLOR_TX)
    g_error ("gpsk31.conf:%d `rx_window_color_tx' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.rx_window_color_tx, scanner->value.v_string);


  /* tx_window_font */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_TX_WINDOW_FONT)
    g_error ("gpsk31.conf:%d `tx_window_font' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.tx_window_font, scanner->value.v_string);

  /* rx_window_font */
  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_RX_WINDOW_FONT)
    g_error ("gpsk31.conf:%d `rx_window_font' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.rx_window_font, scanner->value.v_string);

  /* phase_scope_dcd_on_color */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_PHASE_SCOPE_DCD_ON_COLOR)
    g_error ("gpsk31.conf:%d `phase_scope_dcd_on_color' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.phase_scope_dcd_on_color, scanner->value.v_string);

  /* phase_scope_dcd_off_color */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_PHASE_SCOPE_DCD_OFF_COLOR)
    g_error ("gpsk31.conf:%d `phase_scope_dcd_off_color' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.phase_scope_dcd_off_color, scanner->value.v_string);

  /* phase_scope_arc_color */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_PHASE_SCOPE_ARC_COLOR)
    g_error ("gpsk31.conf:%d `phase_scope_arc_color' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.phase_scope_arc_color, scanner->value.v_string);

  /* Color of the Spectrum Display */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_SPECTRUM_COLOR)
    g_error ("gpsk31.conf:%d `spectrum_color' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.spectrum_color, scanner->value.v_string);

  /* Color of the spectrum tune line */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_SPECTRUM_TUNE_LINE_COLOR)
    g_error ("gpsk31.conf:%d `spectrum_tune_line_color' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.spectrum_tune_line_color, scanner->value.v_string);

  /* callsign of the OP */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_CALLSIGN)
    g_error ("gpsk31.conf:%d `callsign' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.call, scanner->value.v_string);

  /* Name */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_NAME)
    g_error ("gpsk31.conf:%d `name' expected!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.name, scanner->value.v_string);

  /* qth */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_QTH)
    g_error ("gpsk31.conf:%d `qth' expected!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.qth, scanner->value.v_string);

  /* cwid string */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_CW_STRING)
    g_error ("gpsk31.conf:%d `cw_string' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.cw_string, scanner->value.v_string);

  /* Center freq. */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_FREQ)
    g_error ("gpsk31.conf:%d `freq' expected!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_INT)
    g_error ("gpsk31.conf:%d: <number> expected!",
	     g_scanner_cur_line (scanner));
  else
    ini_settings.freq = scanner->value.v_int;

  /* dcd_level */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_DCD_LEVEL)
    g_error ("gpsk31.conf:%d `dcd_level' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_INT)
    g_error ("gpsk31.conf:%d: <number> expected!",
	     g_scanner_cur_line (scanner));
  else
    ini_settings.dcd_level = scanner->value.v_int;

  /* Use LSB for qpsk */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_LSB)
    g_error ("gpsk31.conf:%d `lsb' expected!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_INT)
    g_error ("gpsk31.conf:%d: <number> expected!",
	     g_scanner_cur_line (scanner));
  else
    ini_settings.lsb = scanner->value.v_int;

  /* ptt device */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_PTT_DEVICE)
    g_error ("gpsk31.conf:%d `ptt_device' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.ptt_device, scanner->value.v_string);

  /* audio device */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_AUDIO_DEVICE)
    g_error ("gpsk31.conf:%d `audio_device' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_STRING)
    g_error ("gpsk31.conf:%d: <string> expected!",
	     g_scanner_cur_line (scanner));
  else
    strcpy (ini_settings.audio_device, scanner->value.v_string);

  /* new_rx */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_NEW_RX)
    g_error ("gpsk31.conf:%d `new_rx' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_INT)
    g_error ("gpsk31.conf:%d: <number> expected!",
	     g_scanner_cur_line (scanner));
  else
    ini_settings.new_rx = scanner->value.v_int;

  /* spectrum_width */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_SPECTRUM_WIDTH)
    g_error ("gpsk31.conf:%d `spectrum_width' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_INT)
    g_error ("gpsk31.conf:%d: <number> expected!",
	     g_scanner_cur_line (scanner));
  else
    ini_settings.spectrum_width = scanner->value.v_int;

  /* spectrum_speed */

  g_scanner_get_next_token (scanner);
  if (scanner->token != (int) SYMBOL_SPECTRUM_SPEED)
    g_error ("gpsk31.conf:%d `spectrum_speed' expected!",
	     g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != '=')
    g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
  else
    g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_INT)
    g_error ("gpsk31.conf:%d: <number> expected!",
	     g_scanner_cur_line (scanner));
  else
    ini_settings.spectrum_speed = scanner->value.v_int;

  /* Fixed Texts */

  for (i = SYMBOL_FIRST_FIX; i <= SYMBOL_FIRST_FIX + 30; i = i + 2)
    {
      g_scanner_get_next_token (scanner);
      if (scanner->token != (int) i)
	g_error ("gpsk31.conf:%d `label%d' expected!",
		 g_scanner_cur_line (scanner),
		 (i - SYMBOL_FIRST_FIX) / 2);
      else
	g_scanner_get_next_token (scanner);
      if (scanner->token != '=')
	g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
      else
	g_scanner_get_next_token (scanner);
      if (scanner->token != G_TOKEN_STRING)
	g_error ("gpsk31.conf:%d: <string> expected!",
		 g_scanner_cur_line (scanner));
      else
	strcpy (ini_settings.label[(i - SYMBOL_FIRST_FIX) / 2],
		scanner->value.v_string);

      g_scanner_get_next_token (scanner);
      if (scanner->token != (int) i + 1)
	g_error ("gpsk31.conf:%d `text%d' expected!",
		 g_scanner_cur_line (scanner),
		 (i - SYMBOL_FIRST_FIX) / 2);
      else
	g_scanner_get_next_token (scanner);
      if (scanner->token != '=')
	g_error ("gpsk31.conf:%d `=' missing!", g_scanner_cur_line (scanner));
      else
	g_scanner_get_next_token (scanner);
      if (scanner->token != G_TOKEN_STRING)
	g_error ("gpsk31.conf:%d: <string> expected!",
		 g_scanner_cur_line (scanner));
      else
	strcpy (ini_settings.text[(i - SYMBOL_FIRST_FIX) / 2],
		scanner->value.v_string);

    }
  /* Destroy the scanner and close the file */

  g_scanner_destroy (scanner);
  close (fd);

}

/*
 * This function set all the things
 */

void
set_config ()
{
  int i;
  static int server_started;
  text_allocate ();		/* Allocate the Font/Color for the text widgets */
  phase_scope_init ();		/* Build the Phase Scope GCs */
  draw_arc ();			/* redraw the phase scope circle */
  if (server_started == 0)
    {
      server_started = 1;
      if (strlen (ini_settings.ptt_device) != 0)
	server_main (ini_settings.audio_device, ini_settings.ptt_device, DATADIR);	/* Start Server */
      else
	server_main (ini_settings.audio_device, NULL, DATADIR);
    }
  else
    g_print ("PSK31-Server already started!\n");
  spectrum_offset (ini_settings.freq);
  spectrum_setup ();		/* init the spectrum */
  if (ini_settings.spectrum_width == 0)	/* init fft */
    fft_setup (1024, ini_settings.spectrum_speed);
  else if (ini_settings.spectrum_width == 1)
    fft_setup (2048, ini_settings.spectrum_speed);
  else
    fft_setup (4096, ini_settings.spectrum_speed);
  commControl (COMM_TXCH, COMM_FREQ, 100 * ini_settings.freq);	/* TX Freq */
  commControl (COMM_RXCH, COMM_FREQ, 100 * ini_settings.freq);	/* RX Freq */
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (main_screen.tx_freq), ini_settings.freq);	/* TX Freq spin button */


  gtk_adjustment_set_value (GTK_ADJUSTMENT (main_screen.dcd_adj),
			    (float) (ini_settings.dcd_level * -1));
  commControl (COMM_TXCH, COMM_LSB, ini_settings.lsb);	/* LSB */
  commControl (COMM_RXCH, COMM_LSB, ini_settings.lsb);
  OPTnew = ini_settings.new_rx;	/* Use new rx? */

	set_button (0);		/* set the buttons labels */
}

/*
 * This functions sets the label in the text-buttons
 */

void set_button (int x)
{
	int i;
	for (i = 0; i<= 7; ++i) {
		if (x == 0)
			gtk_label_set_text (GTK_LABEL
                        (GTK_BIN (main_screen.f_button[i])->child),
                        ini_settings.label[i]);
		else
			gtk_label_set_text (GTK_LABEL
                        (GTK_BIN (main_screen.f_button[i])->child),
                        ini_settings.label[i+8]);
	}
}

