/*
 * groach library main header
 * This file should be included by a source that is ouf of library,
 * such as theme modules.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_GROACH_H__
#define __GRO_GROACH_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "grotype.h"
#include "theme.h"
#include "growin.h"
#include "controller.h"
#include "gromove.h"
#include "guimisc.h"


/** Macros and inline functions for external module's ease **/
/** Theme module creator is recommended to use these routines
	than to access data structure directly. **/
/*
 * for GroController
 * All callback functions receive 'const GroController*' as an argument.
 * You can get most of general informations from it.
 */
/**
 * GdkWindow* gcontroller_gdkwindow(const GroController *controller)
 * Return GdkWindow to draw.
 **/
#define gcontroller_gdkwindow(controller)	\
	(controller->gro_win->window)

/**
 * const GdkGC* gcontroller_gdkgc(const GroController *controller)
 * Return GdkGC to use for drawing.
 **/
#define gcontroller_gdkgc(controller)	\
	(controller->gro_win->gc)

/**
 * guint16 gcontroller_window_width(const GroController *controller)
 * Return the width of the window to draw(typically root window).
 **/
#define gcontroller_window_width(controller)	\
	gro_window_width(controller->gro_win)

/**
 * guint16 gcontroller_window_height(const GroController *controller)
 * Return the height of the window to draw(typically root window).
 **/
#define gcontroller_window_height(controller)	\
	gro_window_height(controller->gro_win)

/**
 * is_rect_in_gcontroller_window:
 * Return TRUE, if @rect is in the window(typically root window).
 **/
static inline gboolean
is_rect_in_gcontroller_window(const GroController *controller, const GdkRectangle *rect)
{
	GdkRectangle win_rect;

	gro_window_rectangle(controller->gro_win, &win_rect);
	return is_rect_in_rect(rect, &win_rect);
}

/**
 * guint gcontroller_step_pixel(const GroController *controller)
 * Return the number of step pixels of GroMove.
 **/
#define gcontroller_step_pixel(controller)	\
	(controller->cur_theme->step_pixel)


/*
 * for GroMove
 * Some of callback functions receive 'GroMove*' as an argument.
 * You can get each gmove(roach)'s informations from it.
 */
/**
 * guint16 gmove_width(const GroMove *gmove)
 * Return the width of the gmove.
 **/
#define gmove_width(gmove)	\
	(gmove->cur_rect.width)

/**
 * guint16 gmove_height(const GroMove *gmove)
 * Return the height of the gmove.
 **/
#define gmove_height(gmove)	\
	(gmove->cur_rect.height)

/**
 * gint16 gmove_center_x(const GroMove *gmove)
 * Return the center position x of the gmove.
 **/
#define gmove_center_x(gmove)	\
	(gmove->cur_rect.x + (gmove->cur_rect.width / 2))

/**
 * gint16 gmove_center_y(const GroMove *gmove)
 * Return the center position y of the gmove.
 **/
#define gmove_center_y(gmove)	\
	(gmove->cur_rect.y + (gmove->cur_rect.height / 2))

/**
 * is_gmove_hidden:
 * Return TRUE, if gmove is hidden (under any window).
 **/
static inline gboolean
is_gmove_hidden(const GroMove *gmove, const GdkRegion *vis_region)
{
	GdkOverlapType olap;
	
	olap = gdk_region_rect_in((GdkRegion*)vis_region,
							  (GdkRectangle*)&gmove->cur_rect);
	if (olap == GDK_OVERLAP_RECTANGLE_OUT)
		return TRUE;
	else
		return FALSE;
}

/* Every theme is recommended to call this before motion computation. */
/* (const GroMove *gmove, const GdkRegion *vis_region) */
#define DONTCARE_hidden_gmove(gmove, vis_region) G_STMT_START {	\
	if (is_gmove_hidden(gmove, vis_region))		\
		return GRO_RET_HIDDEN;					\
} G_STMT_END

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_GROACH_H__ */
