/*
 * Pixmap and Bitmap(mask) pair-data module
 * Refer to gropixmap.h about details.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include <gdk_imlib.h>
#include "gropixmap.h"

/**
 * gro_pixmap_new:
 * filename == "" is legal, which implies to clear the old frame.
 * Refer to gro_move_real_move() about it.
 **/
GroPixmap*
gro_pixmap_new(const char *filename, const char *dirname, guint pix_width, guint pix_height)
{
	GroPixmap *gro_pixmap;

	g_return_val_if_fail(filename != NULL, NULL);/* I don't accept this. */

	gro_pixmap = g_new(GroPixmap, 1);

	if (filename[0] == '\0') {
		gro_pixmap->pixmap = NULL;
		gro_pixmap->mask = NULL;
	} else {
		GdkImlibImage *im;
		char *filepath;

		filepath = g_strconcat(dirname, G_DIR_SEPARATOR_S, filename, NULL);
		im = gdk_imlib_load_image(filepath);
		if (im == NULL) {
			g_warning(_("Can't load %s\n"), filepath);
			g_free(filepath);
			g_free(gro_pixmap);
			return NULL;
		}
		if (pix_width == 0)
			pix_width = im->rgb_width;
		if (pix_height == 0)
			pix_height = im->rgb_height;
		
		gdk_imlib_render(im, pix_width, pix_height);
		gro_pixmap->pixmap = gdk_imlib_move_image(im);
		gro_pixmap->mask = gdk_imlib_move_mask(im);

		gdk_imlib_destroy_image(im);
		g_free(filepath);
	}
	
	return gro_pixmap;
}

/**
 * gro_pixmap_delete:
 **/
void
gro_pixmap_delete(GroPixmap *gro_pixmap)
{
	if (gro_pixmap->pixmap)
		gdk_pixmap_unref(gro_pixmap->pixmap);
	if (gro_pixmap->mask)
		gdk_pixmap_unref(gro_pixmap->mask);

	g_free(gro_pixmap);
}
