/* soapC.c
   Generated by gSOAP 2.7.0c from quote.h
   Copyright (C) 2001-2004 Genivia, Inc. All Rights Reserved.
   This software is released under one of the following three licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
   See README.txt for further details.
*/
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_BEGIN_NAMESPACE(soap)

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.0c 2004-10-08 13:37:32 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version != 1 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}

SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_ns__getQuote:
		return soap_in_ns__getQuote(soap, NULL, NULL, "ns:getQuote");
	case SOAP_TYPE_ns__getQuoteResponse:
		return soap_in_ns__getQuoteResponse(soap, NULL, NULL, "ns:getQuoteResponse");
	case SOAP_TYPE_PointerTofloat:
		return soap_in_PointerTofloat(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:getQuote"))
		{	*type = SOAP_TYPE_ns__getQuote;
			return soap_in_ns__getQuote(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:getQuoteResponse"))
		{	*type = SOAP_TYPE_ns__getQuoteResponse;
			return soap_in_ns__getQuoteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_ns__getQuote:
		return soap_out_ns__getQuote(soap, tag, id, (const struct ns__getQuote *)ptr, "ns:getQuote");
	case SOAP_TYPE_ns__getQuoteResponse:
		return soap_out_ns__getQuoteResponse(soap, tag, id, (const struct ns__getQuoteResponse *)ptr, "ns:getQuoteResponse");
	case SOAP_TYPE_PointerTofloat:
		return soap_out_PointerTofloat(soap, tag, id, (float *const*)ptr, "xsd:float");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	switch (type)
	{
	case SOAP_TYPE_ns__getQuote:
		soap_mark_ns__getQuote(soap, (const struct ns__getQuote *)ptr);
		break;
	case SOAP_TYPE_ns__getQuoteResponse:
		soap_mark_ns__getQuoteResponse(soap, (const struct ns__getQuoteResponse *)ptr);
		break;
	case SOAP_TYPE_PointerTofloat:
		soap_mark_PointerTofloat(soap, (float *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_mark_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_mark_string(soap, (char**)&ptr);
		break;
	}
}

#ifndef WITH_LEANER
SOAP_FMAC3 int SOAP_FMAC4 soap_resolve_attachments(struct soap *soap)
{
	if (!(soap->mode & SOAP_ENC_DIME))
		return SOAP_OK;
	while (soap->dime.flags & SOAP_DIME_CF)
	{	if (soap_getdimehdr(soap))
			return soap->error;
		if (soap_move(soap, soap->dime.size))
			return soap->error = SOAP_EOF;
	}
	if (soap_move(soap, ((soap->dime.size+3)&(~3))-soap_tell(soap)))
		return soap->error = SOAP_EOF;
	for (;;)
	{	if (soap_getdime(soap))
			break;
		switch (soap_lookup_type(soap, soap->dime.id))
		{
		}
	}
	if (soap->error == SOAP_DIME_END)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_byte(struct soap *soap, char const*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_int(struct soap *soap, int const*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_float(struct soap *soap, float const*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault const*a)
{
	soap_mark_SOAP_ENV__Fault(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	soap_embedded(soap, &a->faultcode, SOAP_TYPE__QName);
	soap_mark__QName(soap, &a->faultcode);
	soap_embedded(soap, &a->faultstring, SOAP_TYPE_string);
	soap_mark_string(soap, &a->faultstring);
	soap_embedded(soap, &a->faultactor, SOAP_TYPE_string);
	soap_mark_string(soap, &a->faultactor);
	soap_embedded(soap, &a->detail, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	soap_mark_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_embedded(soap, &a->SOAP_ENV__Code, SOAP_TYPE_PointerToSOAP_ENV__Code);
	soap_mark_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_embedded(soap, &a->SOAP_ENV__Reason, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Reason);
	soap_embedded(soap, &a->SOAP_ENV__Detail, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	soap_mark_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	a->faultcode = NULL;
	a->faultstring = NULL;
	a->faultactor = NULL;
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_string(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->alloced)
		soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{	for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode = 0;
					continue;
				}
			if (soap_flag_faultstring && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "faultstring", &a->faultstring, ""))
				{	soap_flag_faultstring = 0;
					continue;
				}
			if (soap_flag_faultactor && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "faultactor", &a->faultactor, ""))
				{	soap_flag_faultactor = 0;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail const*a)
{
	soap_mark_SOAP_ENV__Detail(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->alloced)
		soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{	for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && soap->error == SOAP_TAG_MISMATCH)
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code const*a)
{
	soap_mark_SOAP_ENV__Code(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	soap_embedded(soap, &a->SOAP_ENV__Value, SOAP_TYPE__QName);
	soap_mark__QName(soap, &a->SOAP_ENV__Value);
	soap_embedded(soap, &a->SOAP_ENV__Node, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Node);
	soap_embedded(soap, &a->SOAP_ENV__Role, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Role);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	a->SOAP_ENV__Value = NULL;
	a->SOAP_ENV__Node = NULL;
	a->SOAP_ENV__Role = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->alloced)
		soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{	for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, ""))
				{	soap_flag_SOAP_ENV__Node = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, ""))
				{	soap_flag_SOAP_ENV__Role = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header const*a)
{
	soap_mark_SOAP_ENV__Header(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->alloced)
		soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{	for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__getQuote(struct soap *soap, struct ns__getQuote const*a)
{
	soap_mark_ns__getQuote(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_ns__getQuote(struct soap *soap, const struct ns__getQuote *a)
{
	soap_embedded(soap, &a->symbol, SOAP_TYPE_string);
	soap_mark_string(soap, &a->symbol);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__getQuote(struct soap *soap, struct ns__getQuote *a)
{
	a->symbol = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__getQuote(struct soap *soap, const struct ns__getQuote *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__getQuote);
	if (soap_out_ns__getQuote(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__getQuote(struct soap *soap, const char *tag, int id, const struct ns__getQuote *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__getQuote), type);
	soap_out_string(soap, "symbol", -1, &a->symbol, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__getQuote * SOAP_FMAC4 soap_get_ns__getQuote(struct soap *soap, struct ns__getQuote *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__getQuote(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__getQuote * SOAP_FMAC4 soap_in_ns__getQuote(struct soap *soap, const char *tag, struct ns__getQuote *a, const char *type)
{
	short soap_flag_symbol = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__getQuote *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__getQuote, sizeof(struct ns__getQuote), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->alloced)
		soap_default_ns__getQuote(soap, a);
	if (soap->body && !*soap->href)
	{	for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_symbol && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "symbol", &a->symbol, ""))
				{	soap_flag_symbol = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__getQuote *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ns__getQuote, 0, sizeof(struct ns__getQuote), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__getQuoteResponse(struct soap *soap, struct ns__getQuoteResponse const*a)
{
	soap_mark_ns__getQuoteResponse(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_ns__getQuoteResponse(struct soap *soap, const struct ns__getQuoteResponse *a)
{
	soap_embedded(soap, &a->Result, SOAP_TYPE_PointerTofloat);
	soap_mark_PointerTofloat(soap, &a->Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__getQuoteResponse(struct soap *soap, struct ns__getQuoteResponse *a)
{
	a->Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__getQuoteResponse(struct soap *soap, const struct ns__getQuoteResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__getQuoteResponse);
	if (soap_out_ns__getQuoteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__getQuoteResponse(struct soap *soap, const char *tag, int id, const struct ns__getQuoteResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__getQuoteResponse), type);
	if (a->Result)
		soap_element_result(soap, "Result");
	soap_out_PointerTofloat(soap, "Result", -1, &a->Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__getQuoteResponse * SOAP_FMAC4 soap_get_ns__getQuoteResponse(struct soap *soap, struct ns__getQuoteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__getQuoteResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__getQuoteResponse * SOAP_FMAC4 soap_in_ns__getQuoteResponse(struct soap *soap, const char *tag, struct ns__getQuoteResponse *a, const char *type)
{
	short soap_flag_Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__getQuoteResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__getQuoteResponse, sizeof(struct ns__getQuoteResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->alloced)
		soap_default_ns__getQuoteResponse(soap, a);
	if (soap->body && !*soap->href)
	{	for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTofloat(soap, "Result", &a->Result, ""))
				{	soap_flag_Result = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__getQuoteResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ns__getQuoteResponse, 0, sizeof(struct ns__getQuoteResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	soap_mark_PointerToSOAP_ENV__Code(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_mark_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	soap_mark_PointerToSOAP_ENV__Detail(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_mark_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTofloat(struct soap *soap, float *const*a)
{
	soap_mark_PointerTofloat(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_PointerTofloat(struct soap *soap, float *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_float);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTofloat(struct soap *soap, float *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTofloat);
	if (soap_out_PointerTofloat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTofloat(struct soap *soap, const char *tag, int id, float *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_float);
	if (id < 0)
		return soap->error;
	return soap_out_float(soap, tag, id, *a, type);
}

SOAP_FMAC3 float ** SOAP_FMAC4 soap_get_PointerTofloat(struct soap *soap, float **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTofloat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float ** SOAP_FMAC4 soap_in_PointerTofloat(struct soap *soap, const char *tag, float **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (float **)soap_malloc(soap, sizeof(float *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_float(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (float **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_float, sizeof(float), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{
	soap_mark__QName(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark__QName(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE__QName);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_mark_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_mark_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
}

SOAP_END_NAMESPACE(soap)

#ifdef __cplusplus
}
#endif

/* end of soapC.c */
