//$Id: treeitem.h,v 1.8 2003/06/30 14:07:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_TREEITEM_H
#define GUIKACHU_TREEITEM_H

#include <gtk--/treeitem.h>
#include <gtk--/menu.h>
#include "resource.h"
#include "resource-win.h"

namespace Guikachu
{
    namespace GUI
    {
	class TreeItem: public Gtk::TreeItem
	{
	    Resource       *res;
	    ResourceWindow *res_win;
	    Gtk::Menu       popup_menu;
	    
	public:
	    TreeItem (Resource *res_);
	    
	    Resource * get_resource () const { return res; };
	    
	private:
	    void show_ui ();
	    
	    int button_press_cb (GdkEventButton *e);
	    int key_press_cb (GdkEventKey *e);
	    void resource_changed_cb ();

	    void menu_edit_cb ();
	    void menu_cut_cb ();
	    void menu_copy_cb ();
	    void menu_remove_cb ();
	};
    }
}

#endif /* !GUIKACHU_TREEITEM_H */
