/* preferences.h - Prototypes for functions in preferences.c

   Copyright (C) 2000  Henning Kulander <hennikul@ifi.uio.no>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gnome.h>

#define NDIALS 4
#define NINFO_TYPES 10


typedef struct _InfoDial InfoDial;

struct _InfoDial {
	GtkWidget *canvas;
	gchar *infotype;
	Dial *dial;
	gboolean changed;
	gint n_items;
	GtkWidget *menu_items[NINFO_TYPES];
};

void 
preferences_infodials_clear( void );

void
preferences_set_string_variable( gchar *variable, gchar *value );

gchar 
*preferences_get_string_variable(gchar *variable);

void 
preferences_set_int_variable( gchar *variable, gint value );

void 
preferences_set_bool_variable( gchar *variable, gboolean value );

gboolean 
preferences_load( GtkWidget *widget );

gboolean 
preferences_box_make( GtkWidget *main_widget );

void 
preferences_box_showmenus( GtkWidget *preferences );

gchar*
preferences_hostname_get( void );

gboolean 
preferences_udp_set( gboolean val);

gboolean 
preferences_udp_get( void );

gint 
preferences_delay_get( void );

gchar *
preferences_get_fontname_dials( void );

void 
info_types_clear( void );

void 
info_types_add( char *name, char *description );

gchar *
info_types_get_name( gint number );

InfoDial *
info_dial_get( gint index );

gboolean 
info_types_has( gchar *name );

void 
global_timeout_set( guint id );

guint 
global_timeout_get( void );

gboolean
global_updatetimeout_func( gpointer data );

void 
global_window_set( GtkWidget *w );

GtkWidget* 
global_window_get( void );

void 
global_session_set( gchar *ups_session );

void 
unlock_sync_mutex( void );

void 
lock_sync_mutex( void );

void
unlock_ups_mutex( void );

void
lock_ups_mutex( void );

gboolean make_thread( void );

guint 
start_fetching( void );
