//
// $Id: distribution.h,v 1.1.1.1 2000/11/29 13:20:37 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/distribution.h,v $
// $Revision: 1.1.1.1 $
// $Date: 2000/11/29 13:20:37 $
// $State: Exp $
//
// Author: Mick Dwyer, 2000.
//


#ifndef DISTRIBUTION_H
#define DISTRIBUTION_H

#include "target.h"
#include "String.h"

class Distribution 
{
protected:
	String Name;
public:
	virtual long sample(void) {return 0;} 
	/* return a sample from the distribution */
    virtual ~Distribution() {}
};

class Uniform : public Distribution 
{
	/* defining parameters */
	float	size;
public:
	Uniform(float s) { Name = "Uniform"; size = s;}
	long sample() { /* some code here */ return 0; }
    virtual ~Uniform() {}
};

class Normal : public Distribution 
{
	/* defining parameters */
	float	mean;
	float	variance;
public:
	Normal(float m, float v) { Name = "Normal"; mean = m; variance = v;}
	long sample() { /* some code here */ return 0; }
    virtual ~Normal() {}
};

class Exponential : public Distribution 
{
	/* defining parameters */
	float	mean;
	float	variance;
public:
	Exponential(float m, float v) { Name = "Exponential"; mean = m; variance = v;}
	long sample() { /* some code here */ return 0; }
    virtual ~Exponential() {}
};

class BottleNeck 
{
public:
	String Name;
	Distribution *type; /* the type of distrbution */
	double probability;
};

class ThreadConfig 
{
public:
	HammerTarget target;
	long altif;
};

#endif
