//
//
// HAMMERHEAD: stress testing rig
//
// $Id: hammerhead.cc,v 1.14 2002/11/13 02:57:43 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/hammerhead.cc,v $
// $Revision: 1.14 $
// $Date: 2002/11/13 02:57:43 $
// $State: Exp $
//
// This program should make a large number of requests to the
// given address (in the config file)
//
// Author: Geoff Wong
// See the "Copying" included in this package for copyright details.
//
//
#include <time.h>
#include <sys/time.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/resource.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#ifdef USE_PTHREAD
#include <pthread.h>
#endif

#include "dictionary.h"
//#include "html.h"
#include "str.h"
#include "scenario.h"
#include "statistics.h"
#include "config.h"
#include "hrtime.h"
#include "cmdline.h"

Scenario **scenario_arr;
Scenario **sequence_arr;
int scn_size;
int seq_size;

int Shutdown = 0;
#ifdef USE_PTHREAD
int ExecThreads = 1; 
    /* pthreads */
#else
int ExecThreads = 0; 
    /* unix processes */
#endif

hrtime_t StartedTime = 0;
    // the time we actually started up.

list<int> pids;
    // list of pids for the children.

extern void * thread_main(void *);

#if 0
int operator==(const Dictionary<Scenario *>::iterator& it1,
               const Dictionary<Scenario *>::iterator& it2)
{
    if ((it1.where == it2.where)
        && (it1.ihash == it2.ihash)) return 1;
    return 0;
}
#endif

void sec_sleep(unsigned int sleep_secs) 
{ 
    unsigned int i;
    for (i = 0; i < sleep_secs; i++) 
    { 
        usleep(1000000); 
    } 
} 

//
// Signal handle to shut the show down. Function argument is
//require but unused. Name it if you want to use it.
//

void shutdown(int)
{
    Shutdown = 1;
    //sec_sleep(20);
    //fclose(Scenario::logStream);
    //fclose(Scenario::reportStream);
    //exit(0);
}

/* this is a special for the parent. It is
   installed after forking the children. */
void shutdown_parent(int)
{
    list<int>::iterator pidsit;

    fprintf(Scenario::logStream, "SIGHUP received by parent - shutdown commencing.\n");

    /* send a hup to all my children so they set Shutdown = 1 */
    for(pidsit = pids.begin(); pidsit != pids.end(); pidsit++)
    {
        kill(*pidsit, SIGHUP);
    }  

    sec_sleep(20);

    output_statistics(Scenario::reportStream);

    fclose(Scenario::logStream);
    fclose(Scenario::reportStream);
    exit(0);
}


//
// Signal handler to trigger new DNS resolution.
//

void dnsalarm(int)
{
    DNSTTLExpired = 1;
}

int ReadScenario(String filename, FILE *fp)
{
    int cnt = 0;
    Scenario::lineNum = 0;
    bool moreInFile = true;
    Scenario * scn;

    do
    {
        scn = new Scenario;

        moreInFile = scn->Restore(filename.c_str(), fp);
    
        // only keep a scenario if it has a valid request
        if (scn->request == 0 || scn->request->empty())
        {
            delete scn;
        }
        else
        {
            Scenario::SCN[scn->name.c_str()] = scn;
            cnt++;
        }
        if (cnt % 1000 == 0)
        {
            fprintf(stderr, "%d (%d) ", 
                       cnt, Scenario::allRequests.num_elements());
        }
    } while (moreInFile);
   
    fprintf(Scenario::logStream, "Read %d scenarios from %s\n", 
           cnt, filename.c_str());

    return cnt;
}

int ReadScenarios()
{
    DIR * sdir;
    struct dirent * entry;
    int totalCnt = 0;
    int l;
    String filename;
    list<String>::iterator fileit;
    list<String>::iterator dirit;

    if (ScenarioDirectories.size() != 0) 
        for (dirit = ScenarioDirectories.begin(); dirit != ScenarioDirectories.end(); dirit++)
        {
            String Scenarios = *dirit;

            // get the directory
            sdir = opendir(Scenarios.c_str());
            if (sdir == NULL) 
            {
                fprintf(stderr, "Failed to open scenario directory %s.\n", Scenarios.c_str());
                continue;
            }
            // go through finding ".scn" files and add them to SCN
            entry = readdir(sdir);
            while (entry != NULL)
            {
                filename = entry->d_name;
                l = filename.length();
                if (l < 5 || filename[l-4] != '.' || filename[l-3] != 's' 
                    || filename[l-2] != 'c' || filename[l-1] != 'n') 
                {
                    entry = readdir(sdir);
                    continue;
                }
            
                String fullName = Scenarios + "/" + filename;
                FILE *fp;
                fp = fopen(fullName.c_str(), "r");
                if (fp == NULL)
                {
                    return false;
                }
                totalCnt += ReadScenario(filename, fp);
                fclose(fp);
    
                entry = readdir(sdir);
            }
            closedir(sdir);
        }
    
    // get any files that were explicitly specified
    if (ScenarioFiles.size() != 0) 
        for (fileit = ScenarioFiles.begin(); fileit != ScenarioFiles.end(); fileit++) 
        {
            FILE *fp;

            fp = fopen((*fileit).c_str(), "r");
            if (fp == NULL)
            {
                break;
            }
            totalCnt += ReadScenario(filename, fp);
            fclose(fp);
        }

    fprintf(stderr, "%d Scenarios read\n", totalCnt);

    // resolve scenarios into iterators (for Select_next())
    // TODO
    
    Dictionary<Scenario *>::iterator si;

    for (si = Scenario::SCN.begin(); si != Scenario::SCN.end(); si++)
    {
        Scenario * sc;

        sc = *si;
        if (sc)
        {
            sc->Resolve();
        }
    }

    // at this point, any scenario whose head attribute is 1 is the
    // start of a sequence.

    for (si = Scenario::SCN.begin(); si != Scenario::SCN.end(); si++)
    {
        Scenario * sc;

        sc = *si;

        if (sc)
        {
            if (sc->head == 1)
            {
                // this is the head of a sequence
                // so place it in the sequence dictionary 
                Scenario::SEQ[(*sc).name.c_str()] = sc;
            }
        }

    }

    sequence_arr = Scenario::SEQ.element_array();
    seq_size = Scenario::SEQ.num_elements();
    bool ok = true;

    fprintf(stderr, "Checking sequence_arr, %d elements... ", seq_size);

    for (int i = 0; i < seq_size; i++)
    {
        if (sequence_arr[i] == 0)
        {
            fprintf(stderr, "\nERROR: sequence_arr[%d] = 0", i);
            ok = false;
        }
    }
    if (ok) 
    {
        fprintf(stderr, "OK\n");
    }
    else
    {
        fprintf(stderr, "FAILED\n");
        exit(1);
    }
    
    // set up the array of scenarios, and check that it is ok...
    // obsolete with iterators?
    scenario_arr = Scenario::SCN.element_array();
    scn_size = Scenario::SCN.num_elements();
    ok = true;

    fprintf(stderr,  "Checking scenario_arr, %d elements... ", scn_size);
    for (int i = 0; i < scn_size; i++)
    {
        if (scenario_arr[i] == 0)
        {
            fprintf(stderr, "\nERROR: scenario_arr[%d] = 0", i);
            ok = false;
        }
    }

    if (ok) fprintf(stderr, "OK\n");
    else
    {
        fprintf(stderr, "FAILED\n");
        exit(1);
    }

    return totalCnt;
}

/* This is to fork a single unix process for each session. */
void doProcesses(int runtime)
{
    list<long>::iterator altifit;
    list<HammerTarget>::iterator targetit;
    list<int>::iterator pidsit;
    int doif = 0;
    int process_seed;

    if (Seed == 0)
    {
        Seed = (int )time(0);
    }
    srandom(Seed);
    fprintf(Scenario::logStream, "START: seed = %d, sessions = %d\n", 
            Seed, Sessions);

    fflush(Scenario::logStream);

    if (IpAliases.size() != 0)
    {
        doif = 1;
        altifit = IpAliases.begin();
    }

    targetit = HammerTargets.begin();

    for (int i = 0; i < Sessions; i++)
    {
        int res;
        ThreadConfig *tc = new ThreadConfig();

        tc->altif = 0;
        
        if (doif) 
        {
            //fprintf(stderr, "altif = %d\n", altif);
            tc->altif =  *(altifit);
            altifit++;
            if (altifit == IpAliases.end()) altifit = IpAliases.begin();
        }

        tc->target =  *(targetit);
        targetit++;
        if (targetit == HammerTargets.end()) targetit = HammerTargets.begin();

        /* reseed the random number generator */
        process_seed = random();
        res = fork();
        /* do the fork.... */
        if (res == 0) 
        { 
            /* child */
            /* reseed the process */
            srandom(process_seed);
            thread_main((void *)tc);
            fclose(Scenario::logStream);
            fclose(Scenario::reportStream);
            exit(0);
        }
        else
        {
            /* parent */
            fprintf(stderr,"%d ", res);
            pids.push_back(res);
        }

    }
    fprintf(stderr,"\n");

    // install the parents hangup signal handler
    signal(SIGHUP, shutdown_parent);

    // make sure we don't exit 
    // but also make sure we do something sometimes so we can
    // be interrupted
    if (runtime == 0)
    {
        if (ReportTime == 0)
        {
            while (1)
            {
                sec_sleep(1);
            }
        } 
        else
        {
            /* we want to generate reports at some interval */
            while (1)
            {
                sec_sleep(ReportTime);
                Report(Scenario::reportStream);
            }
        }
    }
    else
    {
        if (runtime > ReportTime && ReportTime > 0)
        {
            /* we'll be generating a number of reports */
            long totaltime = 0;
            while(totaltime < runtime) 
            {
                sec_sleep(ReportTime);
                totaltime += ReportTime;
                Report(Scenario::reportStream);
            }
        }
        else
        {
            sec_sleep(runtime);
        }

        /* send a hup to all my children so they set Shutdown = 1 */
        for(pidsit = pids.begin(); pidsit != pids.end(); pidsit++)
        {
            kill(*pidsit, SIGHUP);
        }    

        sec_sleep(20);

        output_statistics(Scenario::reportStream);
    }
}

/* do threads in a single unix process */
void doThreads(int runtime)
{
#ifdef USE_PTHREAD
    // create the threads
    pthread_attr_t threadattrs;
    size_t ss = 65536;                        /* 16k? */
#endif
    list<long>::iterator altifit;
    list<HammerTarget>::iterator targetit;
    int doif = 0;

#ifdef USE_PTHREAD
    pthread_attr_init(&threadattrs);
#ifndef Linux
    //pthread_attr_setstacksize(&threadattrs, ss);
#endif
#endif

    if (Seed == 0)
    {
        Seed = (int )time(0);
    }
    srandom(Seed);
    fprintf(Scenario::logStream, "START: seed = %d, sessions = %d\n", 
            Seed, Sessions);

    if (IpAliases.size() != 0)
    {
        doif = 1;
        altifit = IpAliases.begin();
    }

    targetit = HammerTargets.begin();

    for (int i = 0; i < Sessions; i++)
    {
#ifdef USE_PTHREAD
        int res;
        pthread_t threadID;
#endif
        ThreadConfig *tc = new ThreadConfig();

        tc->altif = 0;
        
        if (doif) 
        {
            //fprintf(stderr, "altif = %d\n", altif);
            tc->altif =  *(altifit);
            altifit++;
            if (altifit == IpAliases.end()) altifit = IpAliases.begin();
        }

        tc->target =  *(targetit);
        targetit++;
        if (targetit == HammerTargets.end()) targetit = HammerTargets.begin();

#ifdef USE_PTHREAD
        //res = pthread_create(&threadID,&threadattrs,&thread_main,(void *)tc);
        res = pthread_create(&threadID,0,&thread_main,(void *)tc);
        if (res == 0) 
        { 
            /* fuck up? */
            /* the FreeBSD pthread_create code contradicts the
               advice given in the man page. */
        }
        //fprintf(stderr,"%d ", res);
#endif
    }

    fprintf(stderr,"\n");

    // make sure we don't exit 
    // but also make sure we do something sometimes so we can
    // be interrupted
    if (runtime == 0)
    {
        while (1)
        {
            usleep(100000);
        }
    }
    else
    {
        sec_sleep(runtime);
        Shutdown = 1;
        sec_sleep(20);
    }
}

// Tests that we can get the scenarios
// from all the web servers
void testScenarios()
{
    Scenario * sc;
    Session * sess;
    Result * res;
    list<HammerTarget>::iterator targetit;
    Dictionary<Scenario *>::iterator si;

    // loop through machineIP list 
    for (targetit = HammerTargets.begin(); targetit != HammerTargets.end(); targetit++) 
    {
            // create a session to do test 
            sess = new Session();
            sess->port = (*targetit).HammerPort;
            sess->ip_addr = (*targetit).HammerMachine;
            sess->machine = (*targetit).HammerIP;

            // loop through the scenarios 
            for (si = Scenario::SCN.begin(); si != Scenario::SCN.end(); si++)
            {
                sc = *si;
                if (sc)
                {
                    sess->scenario = sc; // jbb 
                    res = sc->Request(sess);
                    if (res == 0)
                    {
                        fprintf(stderr, "Connect failed to server [%s]\n", sess->machine.c_str());
                        break;
                    } 
                    else if (res->returnCode >= 400)
                    {
                        fprintf(stdout, "Got %d from %s for [%s] %s\n", res->returnCode, sess->machine.c_str(), sc->name.c_str(), sc->request->c_str());
                    }
                }
            }
            delete sess;
    }
}

// Writes a new scenario file with all scenarios 
// and expected results useful for long runs
// when we're too lazy to do all the expected stuff.
// Note: probably should trim expected results to a sane length

#define MAX_RESULT_LINES 8
void createResults(char *resultsName)
{
    FILE *resultsStream = fopen(resultsName, "w");
    Session * sess;
    Scenario * scenario;
    Result * res;
    HammerTarget target;

    String result_buffer[MAX_RESULT_LINES+1];

    cout << "Creating compact scenario / results file: " << 
            resultsName << endl;

    // choose an arbitrary target 
    target = *(HammerTargets.begin());

    sess = new Session(1);
    sess->port = target.HammerPort;
    sess->ip_addr = target.HammerMachine;
    sess->machine = target.HammerIP;

    cerr << sess->port << endl;

    scenario_arr = Scenario::SCN.element_array();

    for (int i = 0; i < Scenario::SCN.num_elements(); i++)
    {
        if (i % 1000 == 0)
        {
            cerr << i << " ";
        }

        // choose next scenario in sequence to do
        scenario = scenario_arr[i];

        if (Scenario::allExpected[scenario->request->c_str()] == 0)
        {
            // haven't seen this request yet, so get the result
            sess->scenario = scenario;
            res = scenario->Request(sess);
            // this is a type violation - so probably a bug
            Scenario::allExpected[scenario->request->c_str()] =
                (list<String> *)1;
        }
        else
        {
            res = (Result *)0;
        }

        // print name, request, and think time
        fprintf(resultsStream, "N%s\nR%s\nT%d\n",
                scenario->name.c_str(), scenario->request->c_str(),
                scenario->think);

        // print next in sequence, if there is any (assume only one)
        if (!scenario->next.empty())
        {
            fprintf(resultsStream, "S%s\n", 
                    scenario->SelectNext()->name.c_str());
        }

        if (res != 0)
        {
            // print first few lines of result, if any
            int rLen = res->buffer.size();
            if (rLen > 0)
            {
                int saveLines;
                
                list<String>::iterator resI = res->buffer.begin();

                saveLines = split((*resI), result_buffer, MAX_RESULT_LINES+1, "\n");
                
                for (int j = 0; j < saveLines && j < MAX_RESULT_LINES; j++)
                {
                    fprintf(resultsStream, "E%s\n", result_buffer[j].c_str());
                    resI++;
                }
            }
            delete res;
        }

        // finish off the scenario.
        fprintf(resultsStream, ".\n");
        fflush(resultsStream);
    }
}


void setLimits()
{
    struct rlimit limit;

    /* unlimit the number of file descriptors */
    if (getrlimit(RLIMIT_NOFILE, &limit) < 0 ) perror("getrlimit failed");

    /* set the current limit to maximum. */
    limit.rlim_cur = limit.rlim_max;
    fprintf(stderr, "Setting RLIMIT_NOFILE to %ld\n", limit.rlim_max);
    if (setrlimit(RLIMIT_NOFILE, &limit) < 0) perror("setrlimit failed");

    /* unlimit the datasize */
    if (getrlimit(RLIMIT_DATA, &limit) < 0 ) perror("getrlimit failed");

    /* set the current datasize to max */
    limit.rlim_cur = limit.rlim_max;
    fprintf(stderr, "Setting RLIMIT_DATA to %ldK\n", limit.rlim_max/1024);
    if (setrlimit(RLIMIT_DATA, &limit) < 0) perror("setrlimit failed");

    /* unlimit maxproc */
    if (getrlimit(RLIMIT_NPROC, &limit) < 0 ) perror("getrlimit failed");

    /* set the current maxproc to max */
    limit.rlim_cur = limit.rlim_max;
    fprintf(stderr, "Setting RLIMIT_NPROC to %ld\n", limit.rlim_max);
    if (setrlimit(RLIMIT_NPROC, &limit) < 0) perror("setrlimit failed");

    /* unlimit mem size */
    if (getrlimit(RLIMIT_RSS, &limit) < 0 ) perror("getrlimit failed");

    /* set the current maxproc to max */
    limit.rlim_cur = limit.rlim_max;
    fprintf(stderr, "Setting RLIMIT_RSS to %ld\n", limit.rlim_max);
    if (setrlimit(RLIMIT_RSS, &limit) < 0) perror("setrlimit failed");

    /* unlimit stack size */
    if (getrlimit(RLIMIT_STACK, &limit) < 0 ) perror("getrlimit failed");

    /* set the current maxproc to max */
    limit.rlim_cur = limit.rlim_max;
    fprintf(stderr, "Setting RLIMIT_STACK to %ldK\n", limit.rlim_max/1024);
    if (setrlimit(RLIMIT_STACK, &limit) < 0) perror("setrlimit failed");

}
      

int main(int argc, char *argv[])
{
  //int count = 1;
    int DoTest = 0;
    int CheckConf = 0;
    
    // check commandline options
    Cmdline cl(argc, argv);

    // perhaps move this into cmdline
    if (cl.v())
    {
      cout << argv[0] << " version " << HAMMER_VSN
	   << " more info at http://hammerhead.sourceforge.net" << endl;
      exit(0);
    }
    if (!cl.c().empty()) ConfName = cl.c();

    // Try an unlimit process limits as much as possible
    setLimits();

    // load config file
    if (!OpenConfiguration()) 
    {
        fprintf(stderr, "Couldn't open configuration file.\n");
        exit(1);
    }

    // Now override configfile options if set on cmdline
    if (cl.s()) RunTime = cl.s();
    if (cl.t()) DoTest = TRUE;
    if (cl.C()) CheckConf = TRUE;
    if (!cl.o().empty()) ReportLog = cl.o();
    
    if (CheckConf) 
    {
        fprintf(stderr, "Checked Configuration.\n");
        exit(1);
    }

    if (!DoTest)
    {
        // open the log file
        Scenario::logStream = fopen(HammerLog.c_str(), "a+");
        if (Scenario::logStream == 0)
        {
            fprintf(stderr, "Failed to open log file (using stderr).\n");
            Scenario::logStream = stderr;
        }
    
        // open the log file
        Scenario::reportStream = fopen(ReportLog.c_str(), "a+");
        if (Scenario::reportStream == 0)
        {
            fprintf(stderr, "Failed to open report file (%s - using log file instead).\n",
                ReportLog.c_str());
            Scenario::reportStream = Scenario::logStream;
        }
    }
    else
    {
        // No logging to file - we're testing scenarios.
        Scenario::logStream = stderr;
        Scenario::reportStream = stderr;
    }

    // initialise statistics gathering stuff
    initialise_statistics();

    // read scenarios
    if (ReadScenarios() == 0)
    {
        fprintf(stderr, "Failed to find any scenarios.\n");
        exit(1);
    }
    
#ifdef Solaris
    //sigignore(SIGALRM);
#else
    //signal(SIGALRM, SIG_IGN);
#endif

    signal(SIGALRM, dnsalarm);
    signal(SIGHUP, shutdown);

    if (DoTest) 
    {
        // Actually test the scenarios on each server
        testScenarios();
        exit(0);
    }

    // Ok - we're about to start after reading in all the 
    // configuration stuff and scenarions
    StartedTime = gethrtime();
    
    // resultfile operand if present
    if (cl.has_more_params())
    {
        // this is quite a bit like test .. hmmm
        int nextparam = cl.next_param();
        createResults(argv[nextparam]);
    }
    else
    {
        if (ExecThreads) 
        {
            doThreads(RunTime);
            printf("outputting results\n");
            output_statistics(Scenario::reportStream);
            fclose(Scenario::logStream);
            fclose(Scenario::reportStream);
        }
        else
        { 
            /* processes */
            doProcesses(RunTime);
            cerr << "Outputting results to " << ReportLog << endl;
            fclose(Scenario::logStream);
            fclose(Scenario::reportStream);
        }
    }

}

