
//
// A File Reader 
//
// Provides support for reading in conf/script files.
// 
// $Id: reader.cc,v 1.3 2001/06/22 00:40:44 dredd Exp $
// 
// $Source: /cvsroot/hammerhead/hammerhead/src/reader.cc,v $
// $Revision: 1.3 $
// $Date: 2001/06/22 00:40:44 $
// $State: Exp $
// $Log: reader.cc,v $
// Revision 1.3  2001/06/22 00:40:44  dredd
// Removed various compiler warnings.
//
// Revision 1.2  2001/06/06 12:08:14  dredd
// A few cleans ups so we don't get pointless "Unknown Configuration Directives".
// Also added a basic "INSTALL" document. Fixed a bug in reader.cc.
//
// Revision 1.1.1.1  2000/11/29 13:20:13  dredd
//
//
// Initial hammerhead 2 import for sourceforge.
//
//
// Revision 1.2  2000/10/17 02:45:15  geoff
//
//
// Fixed a dependency problem in makefiles.
// Updated program server (with a static file reader for programs).
// Updated "TODO"s a little.
//
// Revision 1.1  2000/10/13 06:33:23  geoff
//
//
// Another support law.
//
//
// Author: Geoff Wong
// Copyright (C) 1999.
// Zikzak Tech Standard Library Code.
//
// Notes:
//      Reader objects should be created 1 per file pointer.
//      Should be destructed when finished.
//


#include "reader.h"

#if 0
const string DEFAULT_WHITESPACE = " \t\n";
const string DEFAULT_COMMENT = "#";
    string comment;
        // comments are ignored to EOL.
    string whitespace;
        // whitespace chars.
    FILE * fp;
        // current file we're working on.
#endif
    
Reader::Reader(const string& file)
{
    fp = fopen(file.c_str(), "r");
    comment = DEFAULT_COMMENT;
    if (fp != NULL) _eof = false;
    else _eof = true;
    whitespace = DEFAULT_WHITESPACE;
}

Reader::~Reader()
{
    if (fp != NULL) fclose(fp);
}

string Reader::get_line()
{
    int c, i = 0;
    char buf[MAX_LINE+1];
    string ret;

    if (fp == NULL) return "";

    while ( ((c = fgetc(fp)) != EOF) && (i < MAX_LINE))
    {
        if (c == '\n') break;
        buf[i++] = c;    
    }
    buf[i] = '\0';

    if (c == EOF) _eof = true;

    ret = buf;
    return ret;
}

string Reader::get_script_line()
{
    int c, i = 0;
    char buf[MAX_LINE+1];
    string ret;

    if (fp == NULL) return "";

    while ( ((c = fgetc(fp)) != EOF) && (i < MAX_LINE))
    {
        if (c == '#') 
        {
            skip_comment();
            // if i == 0 then the entire line was a comment
            if (i != 0) break;
            else continue;
        }
        if (c == '\n') break;
        buf[i++] = c;    
    }
    buf[i] = '\0';

    if (c == EOF) _eof = true;
    ret = buf;
    return ret;
}

string Reader::get_word()
{
    int c, i = 0;
    char buf[MAX_LINE+1];
    string ret;

    skip_whitespace();

    while ( ((c = fgetc(fp)) != EOF) && (i < MAX_LINE))
    {
        if (c == '#') 
        {
            skip_comment();
            // if i == 0 then the entire line was a comment
            if (i != 0) break;
            else continue;
        }
        if ((int)whitespace.find(c) != -1) break;
        if (c == '\n') break;
        buf[i++] = c;
    }
    buf[i] = '\0';

    if (c == EOF) _eof = true;
    ret = buf;
    return ret;
}

bool Reader::eof()
{
    return _eof;
}

void Reader::skip_whitespace()
{
    int c;

    while ((c = fgetc(fp)) != EOF)
    {
        if ((int)whitespace.find(c) == -1) break;
    }
    if (c != EOF) ungetc(c, fp);
}

void Reader::skip_comment()
{
    int c;

    while ((c = fgetc(fp)) != EOF)
    {
        if (c == '\n') break;
    }
}
