#ifndef _STACK_H_
#define _STACK_H_

template <class Object, class Array>
class Stack {
public:

	inline Stack (void);

	// Push an object onto the stack.
	inline void push (Object o);

	// Pop an object off of the stack.
	inline Object pop (void);

	// Look at the top of the stack.
	inline Object& top (void);

	// Is the stack empty?
	inline bool empty (void);

private:

	// The number of items on the stack.
	int _length;

	// The array implementation of the stack.
	Array _a;
};


template <class Object, class Array>
Stack<Object,Array>::Stack (void)
	: _length (0)
{}


template <class Object, class Array>
void Stack<Object,Array>::push (Object o)
{
	_a[_length] = o;
	_length++;
	assert (!empty());
}


template <class Object, class Array>
Object Stack<Object,Array>::pop (void)
{
	assert (!empty());
	_length--;
	return _a[_length];
}


template <class Object, class Array>
Object& Stack<Object,Array>::top (void)
{
	assert (!empty());
	return _a[_length - 1];
}


template <class Object, class Array>
bool Stack<Object,Array>::empty (void)
{
	return (_length == 0);
}


#endif
