/*****************************************************************************/

/*
 *      mktables.c  --  Linux soundcard DCF77 utilities table generator.
 *
 *      Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

/*****************************************************************************/
      
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>

#include "dcf77.h"

/* --------------------------------------------------------------------- */

static void gen_costab(FILE *f)
{
	unsigned int u;

	fputs("/*\n * this file is automatically generated, do not edit!\n */\n\n"
	      "#include \"dcf77.h\"\n\n"
	      "const short costab[COSTAB_SIZE] = {\n\t", f);
	for (u = 0; u < COSTAB_SIZE; u++) {
		fprintf(f, "%6d", (int)(32767 * cos(2.0 * M_PI * u / COSTAB_SIZE)));
		if (u >= COSTAB_SIZE-1)
			continue;
		if ((u & 7) == 7)
			fputs(",\n\t", f);
		else
			fputs(", ", f);
	}
	fputs("\n};\n", f);
}

/* --------------------------------------------------------------------- */

static void gen_pntab(FILE *f)
{
	unsigned int cnt = 1;  /* insert null bit at the beginning (to balance 0 and 1 frequency) */
	unsigned int word = 0;
	unsigned int phase = 1;
	unsigned int u;

	fputs("/*\n * this file is automatically generated, do not edit!\n */\n\n"
	      "#include \"dcf77.h\"\n\n"
	      "const unsigned int pn_tab[PN_LENGTH>>PN_LOGWORDSIZE] = {\n\t", f);
	for (; cnt < PN_LENGTH;) {
		phase <<= 1;
		u = ((phase >> 5) ^ (phase >> 9)) & 1;
		phase |= u;
		word |= u << (cnt & ((1 << PN_LOGWORDSIZE)-1));
		cnt++;
		if (cnt & ((1 << PN_LOGWORDSIZE)-1))
			continue;
		fprintf(f, "0x%08x", word);
		word = 0;
		if (cnt >= PN_LENGTH-1)
			continue;
		if (cnt & (3<<PN_LOGWORDSIZE))
			fputs(", ", f);
		else
			fputs(",\n\t", f);
	}
	fputs("\n};\n", f);
}

/* --------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	
	if (argc < 2) {
		fprintf(stderr, "usage: %s <tblnum>\n", argv[0]);
		exit(1);
	}
	switch(strtol(argv[1], NULL, 0)) {
	case 1:
		gen_costab(stdout);
		break;

	case 2:
		gen_pntab(stdout);
		break;

	default:
		fputs("unknown table\n", stderr);
		exit(1);
	}
	exit(0);
}

/* --------------------------------------------------------------------- */
