// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_mysqlclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include <mysql.h>
#include <hk_mysqldatabase.h>
#include <hk_mysqlconnection.h>
#include <hk_mysqltable.h>
#include <hk_mysqlresultquery.h>
#include <hk_mysqlactionquery.h>
hk_mysqldatabase::hk_mysqldatabase(hk_mysqlconnection* c):hk_database(c)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqldatabase::hk_mysqldatabase");
#endif
    p_mysqlconnection=c;
}


hk_mysqldatabase::~hk_mysqldatabase(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqldatabase::~hk_mysqldatabase");
#endif

}


hk_mysqlconnection* hk_mysqldatabase::connection(void)
{
    return p_mysqlconnection;
}


void hk_mysqldatabase::driver_specific_tablelist(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqldatabase::driver_specific_tablelist");
#endif
    MYSQL_RES* Res;
    MYSQL_ROW row;
    char *wild=NULL;
    unsigned int i;
    p_tablelist.erase(p_tablelist.begin(),p_tablelist.end());
    if (p_mysqlconnection!=NULL)
    {
        if (p_mysqlconnection->connect())
        {
            Res=mysql_list_tables(p_mysqlconnection->dbhandler(),wild);
            if (Res==NULL) return ;
            while ((row=mysql_fetch_row(Res)))
            {
                for (i=0; i<mysql_num_fields(Res);i++)
                {
                    p_tablelist.insert(p_tablelist.end(),row[i]);
                }
            }
            mysql_free_result(Res);
        }
    }
    sort(p_tablelist.begin(),p_tablelist.end());

}


hk_datasource* hk_mysqldatabase::driver_specific_new_table(hk_presentation* p)
{
    return new hk_mysqltable(this,p);
}


hk_datasource* hk_mysqldatabase::driver_specific_new_resultquery(hk_presentation* p)
{
    return new hk_mysqlresultquery(this,p);
}


hk_actionquery* hk_mysqldatabase::driver_specific_new_actionquery(void)
{
    return new hk_mysqlactionquery(this);
}


bool hk_mysqldatabase::driver_specific_select_db(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_mysqldatabase::driver_specific_select_db");
#endif
    if (p_mysqlconnection!=NULL)
    {
        if (mysql_select_db(p_mysqlconnection->dbhandler(),name().c_str())==0)return true;
    }
    return false;
}



bool    hk_mysqldatabase::driver_specific_rename_table(const hk_string& oldname,const hk_string& newname)
{
   hk_mysqlactionquery* query=new hk_mysqlactionquery(this);
  hk_string sql="ALTER TABLE "+query->identifierdelimiter()+oldname+query->identifierdelimiter()+" RENAME TO "+query->identifierdelimiter()+newname+query->identifierdelimiter();
   query->set_sql(sql.c_str(),sql.size());
   bool res=query->execute();
   delete query;
   return res;

}


