@echo off

REM hfont.bat
REM ---------
REM	written by koaunghi.un@zdv.uni-tuebingen.de
REM	with help of Wonkoo Kim, wkim+@pitt.edu

REM What this file does.
REM --------------------
REM Moves tfm files to $TEXTFMS.
REM Runs mfjob for TARGET.
REM	makes pk files in pk\TARGET\@Rrdpi,
REM	      log files in log\TARGET,
REM	      tfm files in $EMTEXDIR\tfm\TARGET.
REM Runs fontlib for TARGET.
REM	generates response file, TARGET.rsp,
REM	reads pk-files in pk\TARGET\@Rrdpi,
REM	writes fli file for TARGET in DIR.

REM Please edit lines below.
REM ------------------------
REM "current" is, where you are now.
REM "mode" is for printer, for which you make fli files.
REM	see \emtex\mfjob\modes.mfj.
REM     For example "lj" for laserjet.
REM "res" is the resolution of above printer. See also modes.mfj
REM targets are listed below.
REM	"hangul" and "hgextra" are for hangul fonts, which you intend to use.
REM	"hanja" and "hjextra" are for hanja fonts.
REM	"hsymbol" is for hangul symbol fonts.
REM	"jamo" is for jamo fonts.
REM	"johab" is for johab fonts.
REM If you omit some fonts, edit the line "fonts=" in
REM     hangul.mfj, hsymbol.mfj, hgextra.mfj, hanja.mfj, hjextra.mfj,
REM	jamo.mfj and/or johab.mfj.
REM "dir" is normally c:\texfonts, where the fli files go.
REM     pk, tfm and log files are created in the current directory.
REM set "del_pk" to "no", if you want to keep pk files alive.
REM	Once you have made fli files, you don't need pk files anymore.
REM "mf_opt" is the option for running mfjob.
REM	This is normally set by emTeX's install.exe, so this variable can
REM	be omitted.

set current=c:\temp\emtex

set mode=lqh
set res=360
set hangul=mj gt
set hgextra=gr sm gs mg ol yt pn bm pg
set hanja=mj gt
set hjextra=gs
set hsymbol=mj gt
set jamo=mj gt nv sr tt
set johab=mj gt pn
set dir=c:\texfonts
set del_pk=yes
set del_pk=no
REM set mfj_opt=/3

REM No need to change lines below.
REM ------------------------------

set MFINPUT=%EMTEXDIR%\mfinput!;%current%\source\korean!

:hangul
if %hangul%/ == / goto hsymbol
md %EMTEXDIR%\tfm\hangul
for %%I in (%hangul%) do move tfm\korean\ws%%I\*.tfm %EMTEXDIR%\tfm\hangul
mfjob %mfj_opt% hangul.mfj
for %%I in (%hangul%) do call hfontfli /v %mode% %res% %dir% hangul %%I
if %del_pk%/ == no/ goto hsymbol
emdelete -s -y -f pk\hangul\ws*.pk

:hsymbol
if %hsymbol%/ == / goto hgextra
md %EMTEXDIR%\tfm\hsymbol
if not exist tfm\korean\myoungjo\mj0m04.tfm goto no_hsmj
cd tfm\korean\myoungjo
move mj0m04.tfm %EMTEXDIR%\tfm\hsymbol
move mj0m05.tfm %EMTEXDIR%\tfm\hsymbol
move mj0m06.tfm %EMTEXDIR%\tfm\hsymbol
move mj0m07.tfm %EMTEXDIR%\tfm\hsymbol
move mj0mo04.tfm %EMTEXDIR%\tfm\hsymbol
move mj0mo05.tfm %EMTEXDIR%\tfm\hsymbol
move mj0mo06.tfm %EMTEXDIR%\tfm\hsymbol
move mj0mo07.tfm %EMTEXDIR%\tfm\hsymbol
cd ..\..\..
:no_hsmj
if not exist tfm\korean\gothic\gt0m04.tfm goto no_hsgt
cd tfm\korean\gothic
move gt0m04.tfm %EMTEXDIR%\tfm\hsymbol
move gt0m05.tfm %EMTEXDIR%\tfm\hsymbol
move gt0m06.tfm %EMTEXDIR%\tfm\hsymbol
move gt0m07.tfm %EMTEXDIR%\tfm\hsymbol
move gt0mo04.tfm %EMTEXDIR%\tfm\hsymbol
move gt0mo05.tfm %EMTEXDIR%\tfm\hsymbol
move gt0mo06.tfm %EMTEXDIR%\tfm\hsymbol
move gt0mo07.tfm %EMTEXDIR%\tfm\hsymbol
cd ..\..\..
:no_hsgt
mfjob %mfj_opt% hsymbol.mfj
for %%I in (%hsymbol%) do call hfontfli /v %mode% %res% %dir% hsymbol %%I
if %del_pk%/ == no/ goto hgextra
emdelete -s -y -f pk\hsymbol\mj0*.pk
emdelete -s -y -f pk\hsymbol\gt0*.pk

:hgextra
if %hgextra%/ == / goto hanja
if not exist %EMTEXDIR%\tfm\hangul md %EMTEXDIR%\tfm\hangul
for %%I in (%hgextra%) do move tfm\korean\ws%%I\*.tfm %EMTEXDIR%\tfm\hangul
mfjob %mfj_opt% hgextra.mfj
for %%I in (%hgextra%) do call hfontfli /v %mode% %res% %dir% hangul %%I
if %del_pk%/ == no/ goto hanja
emdelete -s -y -f pk\hanja\ws*.pk

:hanja
if %hanja%/ == / goto hjextra
md %EMTEXDIR%\tfm\hanja
if not exist tfm\korean\myoungjo\mj0m10.tfm goto no_hjmj
cd tfm\korean\myoungjo
move mj0m1?.tfm %EMTEXDIR%\tfm\hanja
move mj0m2?.tfm %EMTEXDIR%\tfm\hanja
move mj0mo1?.tfm %EMTEXDIR%\tfm\hanja
move mj0mo2?.tfm %EMTEXDIR%\tfm\hanja
cd ..\..\..
:no_hjmj
if not exist tfm\korean\gothic\gt0m10.tfm goto no_hjgt
cd tfm\korean\gothic
move gt0m1?.tfm %EMTEXDIR%\tfm\hanja
move gt0m2?.tfm %EMTEXDIR%\tfm\hanja
move gt0mo1?.tfm %EMTEXDIR%\tfm\hanja
move gt0mo2?.tfm %EMTEXDIR%\tfm\hanja
cd ..\..\..
:no_hjgt
mfjob %mfj_opt% hanja.mfj
for %%J in (%hanja%) do call hfontfli /v %mode% %res% %dir% hanja %%J
if %del_pk%/ == no/ goto hjextra
emdelete -s -y -f pk\hanja\mj0*.pk
emdelete -s -y -f pk\hanja\gt0*.pk

:hjextra
if %hjextra%/ == / goto jamo
if not exist tfm\korean\gungseo\gs0m10.tfm goto no_hjgs
cd tfm\korean\gungseo
move gs0m1?.tfm %EMTEXDIR%\tfm\hanja
move gs0m2?.tfm %EMTEXDIR%\tfm\hanja
move gs0mo1?.tfm %EMTEXDIR%\tfm\hanja
move gs0mo2?.tfm %EMTEXDIR%\tfm\hanja
cd ..\..\..
:no_hjgs
mfjob %mfj_opt% hjextra.mfj
for %%I in (%hjextra%) do call hfontfli /v %mode% %res% %dir% hanja %%I
if %del_pk%/ == no/ goto jamo
emdelete -s -y -f pk\hanja\gs0*.pk

:jamo
if %jamo%/ == / goto johab
md %EMTEXDIR%\tfm\jamo
if exist tfm\korean\jamo\jmtt10.tfm move tfm\korean\jamo\*.tfm %EMTEXDIR%\tfm\jamo
if not exist vf\korean\jamo\jmtta.vf goto no_jmvf
if not exist %dir%\vf md %dir%\vf
md %dir%\vf\jamo
move vf\korean\jamo\*.vf %dir%\jamo
:no_jmvf
mfjob %mfj_opt% jamo.mfj
call hfontfli /v %mode% %res% %dir% jamo all
if %del_pk%/ == no/ goto johab
emdelete -s -y -f pk\jamo\jm*.pk

:johab
if %johab%/ == / goto end
md %EMTEXDIR%\tfm\johab
if not exist tfm\korean\myoungjo\mj0m01.tfm goto no_jhmj
cd tfm\korean\myoungjo
move mj0m01.tfm %EMTEXDIR%\tfm\johab
move mj0m02.tfm %EMTEXDIR%\tfm\johab
move mj0m03.tfm %EMTEXDIR%\tfm\johab
move mj0mo01.tfm %EMTEXDIR%\tfm\johab
move mj0mo02.tfm %EMTEXDIR%\tfm\johab
move mj0mo03.tfm %EMTEXDIR%\tfm\johab
move mjm??.tfm %EMTEXDIR%\tfm\johab
move mjmo??.tfm %EMTEXDIR%\tfm\johab
cd ..\..\..
:no_jhmj
if not exist tfm\korean\gothic\gt0m01.tfm goto no_jhgt
cd tfm\korean\gothic
move gt0m01.tfm %EMTEXDIR%\tfm\johab
move gt0m02.tfm %EMTEXDIR%\tfm\johab
move gt0m03.tfm %EMTEXDIR%\tfm\johab
move gt0mo01.tfm %EMTEXDIR%\tfm\johab
move gt0mo02.tfm %EMTEXDIR%\tfm\johab
move gt0mo03.tfm %EMTEXDIR%\tfm\johab
move gtm??.tfm %EMTEXDIR%\tfm\johab
move gtmo??.tfm %EMTEXDIR%\tfm\johab
cd ..\..\..
:no_jhgt
if not exist tfm\korean\pen\pn0m01.tfm goto no_jhpn
cd tfm\korean\pen
move pn0m01.tfm %EMTEXDIR%\tfm\johab
move pn0m02.tfm %EMTEXDIR%\tfm\johab
move pn0m03.tfm %EMTEXDIR%\tfm\johab
move pn0mo01.tfm %EMTEXDIR%\tfm\johab
move pn0mo02.tfm %EMTEXDIR%\tfm\johab
move pn0mo03.tfm %EMTEXDIR%\tfm\johab
move pnm??.tfm %EMTEXDIR%\tfm\johab
move pnmo??.tfm %EMTEXDIR%\tfm\johab
cd ..\..\..
:no_jhpn
if not exist vf\korean\myoungjo\mjm01.vf goto no_mjvf
if not exist %dir%\vf md %dir%\vf
if not exist %dir%\vf\johab md %dir%\vf\johab
move vf\korean\myoungjo\mjm*.vf %dir%\vf\johab
:no_mjvf
if not exist vf\korean\gothic\gtm01.vf goto no_gtvf
if not exist %dir%\vf md %dir%\vf
if not exist %dir%\vf\johab md %dir%\vf\johab
move vf\korean\gothic\gtm*.vf %dir%\vf\johab
:no_gtvf
if not exist vf\korean\pen\pnm01.vf goto no_pnvf
if not exist %dir%\vf md %dir%\vf
if not exist %dir%\vf\johab md %dir%\vf\johab
move vf\korean\pen\pnm*.vf %dir%\vf\johab
:no_pnvf
mfjob %mfj_opt% johab.mfj
call hfontfli /v %mode% %res% %dir% johab all
if %del_pk%/ == no/ goto end
emdelete -s -y -f pk\johab\mj0*.pk
emdelete -s -y -f pk\johab\gt0*.pk
emdelete -s -y -f pk\johab\pn0*.pk

:end

set mode=
set res=
set hangul=
set hgextra=
set hanja=
set hjextra=
set symbol=
set jamo=
set johab=
set dir=
set del_pk=
set current=
set mfinput=
rem set mfj_opt=
