/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

/** Interfaz de los objetos que se cargan y salvan a fichero.
 * @file    JLoadSave.h
 * @author  Juan Carlos Seijo Pérez
 * @date    24/12/2003
 * @version 0.0.1 - 24/12/2003 - Primera versión.
 */

#ifndef _JLOADSAVE_INCLUDED
#define _JLOADSAVE_INCLUDED

#include <JLib/Util/JTypes.h>
#include <JLib/Util/JObject.h>
#include <JLib/Util/JFile.h>

/** Interfaz de los objetos que se cargan y salvan a fichero.
 * Contiene métodos a implementar en las clases que hereden de ella
 * para cargar y salvar datos a un fichero.
 */
class JLoadSave
{
public:
  /** Carga el objeto desde la posición actual del fichero dado.
   * @param  f Fichero abierto y posicionado para cargar el objeto.
   * @return 0 si todo va bien, 1 en caso de error de E/S.
   * 2 en caso de incoherencia de los datos.
   */
  virtual u32 Load(JFile &f) = 0;
  
  /** Salva el objeto en la posición actual del fichero dado.
   * @param  f Fichero abierto y posicionado para salvar el objeto.
   * @return 0 si todo va bien, 1 en caso de error de E/S.
   * 2 en caso de incoherencia de los datos.
   */
  virtual u32 Save(JFile &f) = 0;

  /** Destruye el objeto. Actualmente no hace nada.
   */
  virtual ~JLoadSave() {}
};

#endif  // _JLOADSAVE_INCLUDED
