/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: MidiActivityWidget.h,v 1.4 2004/01/26 11:17:48 comix Exp $
 *
 */


#ifndef MIDI_ACTIVITY_WIDGET_H
#define MIDI_ACTIVITY_WIDGET_H

#include <string>
using std::string;
#include <iostream>
using std::cout;

#include "config.h"
#include "qwidget.h"
#include "qpixmap.h"
#include "qpainter.h"
#include "qtimer.h"

#include "lib/EngineListener.h"

/**
 * Shows midi activity
 */
class MidiActivityWidget : public QWidget, public EngineListener
{
	Q_OBJECT

	public:
		/** Constructor */
		MidiActivityWidget(QWidget * parent, const char * name = 0);

		/** Destructor */
		~MidiActivityWidget();

		void setValue(uint newValue);
		uint getValue();

		void mousePressEvent(QMouseEvent *ev);
		void paintEvent(QPaintEvent *ev);

	public slots:
		void updateMidiActivityWidget();

	private:
		uint value;

		static const uint WIDTH = 50;
		static const uint HEIGHT = 20;

		QPixmap temp;
		QPixmap back;
		QPixmap leds;

		bool changed;

		virtual void midiActivityEvent();
		void customEvent( QCustomEvent *ev );

};


#endif
