'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id$
'\"
.so man.macros
.TH Widget n 3.0 itk "[incr\ Tk]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Widget \- base class for mega-widgets within a frame
.SH "INHERITANCE"
itk::Archetype <- itk::Widget
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.BE

.SH DESCRIPTION
.PP
The \fBWidget\fR class inherits everything from the \fBArchetype\fR
class, and adds a Tk frame called the "hull" component to represent
the body of the mega-widget.  The window class name for the hull
is set to the most-specific class name for the mega-widget.
The protected variable \fBitk_interior\fR contains the window
path name for the "hull" component.  Derived classes specialize
this widget by packing other widget components into the hull.
.PP
Since the hull for the \fBWidget\fR class is implemented with a
Tk frame, mega-widgets in the \fBWidget\fR class can be packed
into other frames and toplevels.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBhull\fR
Class:	\fBFrame\fR
.fi
.IP
The "hull" component acts as the body for the entire mega-widget.
Other components are packed into the hull to further specialize
the widget.

.SH EXAMPLE
.PP
The following example implements a simple \fBTextDisplay\fR
mega-widget.  It creates a read-only display of text with
a text widget and a scrollbar.
.CS
option add *TextDisplay.wrap none widgetDefault
option add *TextDisplay.textBackground ivory widgetDefault
option add *TextDisplay.width 40 widgetDefault
option add *TextDisplay.height 10 widgetDefault

class TextDisplay {
    inherit itk::Widget

    constructor {args} {
        itk_component add text {
            text $itk_interior.info -state disabled \
                -yscrollcommand [code $itk_interior.sbar set]
        } {
            usual
            keep -tabs -wrap -width -height
            rename -background -textbackground textBackground Background
        }
        pack $itk_component(text) -side left -expand yes -fill both

        itk_component add scrollbar {
            scrollbar $itk_interior.sbar \
                -command [code $itk_interior.info yview]
        }
        pack $itk_component(scrollbar) -side right -fill y

        eval itk_initialize $args
    }

    public method display {info}
    public method append {info}
}

body TextDisplay::display {info} {
    $itk_component(text) configure -state normal
    $itk_component(text) delete 1.0 end
    $itk_component(text) insert 1.0 $info
    $itk_component(text) configure -state disabled
}

body TextDisplay::append {info} {
    $itk_component(text) configure -state normal
    $itk_component(text) insert end $info
    $itk_component(text) configure -state disabled
}

usual TextDisplay {
    keep -background -cursor -foreground -font
    keep -activebackground -activerelief
    keep -highlightcolor -highlightthickness
    keep -insertbackground -insertborderwidth -insertwidth
    keep -insertontime -insertofftime
    keep -selectbackground -selectborderwidth -selectforeground
    keep -textbackground -troughcolor
}

#
# EXAMPLE:  Display the /etc/passwd file
#
TextDisplay .file -background red
pack .file

\&.file display [exec cat /etc/passwd]
.CE

.SH KEYWORDS
itk, Archetype, Widget, mega-widget
