/*****************************************************************************
 *                              CursorMgr.cc
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#include "CursorMgr.h"
#include "SdbReader.h"
#include "SdbrCursor.h"
#include "CallbackMgr.h"

/*************************************************************
 * CursorMgr::CursorMgr()
 *************************************************************/
CursorMgr::CursorMgr(Tcl_Interp *interp, SdbReader *sdbr)
{
/*    d_cursors = new Vector<SdbrCursor>(); */

    d_sortValid = false;
    this->instName = sdbr->getInstName();

    this->interp = interp;
    this->sdbr = sdbr;
    cursorIdx = 0;

    d_CursorListCB = CallbackMgr::GetCbList(CBTYPE_CURSOR_LIST_UPDATE, 
            sdbr->getInstName());
    d_CursorUpdateCB = CallbackMgr::GetCbList(CBTYPE_CURSOR_POS_CHANGE,
            sdbr->getInstName());
}

/*************************************************************
 * ~CursorMgr()
 *************************************************************/
CursorMgr::~CursorMgr()
{
/*    delete d_cursors; */
}

/*************************************************************
 * nearestCursor()
 *************************************************************/
SdbrCursor *CursorMgr::nearestCursor(
    Uint32 targetTime,
    Uint32 lowerBound,
    Uint32 upperBound,
    Uint32 tolerance)
{
    SdbrCursor    *ret = 0, *tmp;
    Uint32         i;
    Uint32         distance = 0xFFFFFFFF, delta;
    Uint32         time;

    for (i=0; i<d_cursors.length(); i++) {
        if (!(tmp = d_cursors.idx(i))) {
            continue;
        }

        time = tmp->getTime();

        if (time >= lowerBound && time <= upperBound) {
            if (time >= targetTime) {
                delta = time - targetTime;
            } else {
                delta = targetTime - time;
            }

            if ((delta <= tolerance) && (delta < distance)) {
                ret = tmp;
            }
        }
    }

    return ret;
}

/*************************************************************
 * addCursor()
 *************************************************************/
SdbrCursor *CursorMgr::addCursor(void)
{
    Uint32 idx = d_cursors.length();
    SdbrCursor *cursor;

    cursor = new SdbrCursor(interp, this, idx+1);

    d_cursors.append(cursor);
    d_sortCursors.append(cursor);
    d_sortValid = false;

    for (Uint32 i=0; i<d_cursors.length(); i++) {
        d_cursors.idx(i)->setIdx(i);
    }

    update_list();

    return cursor;
}

/*************************************************************
 * delCursor()
 *************************************************************/
void CursorMgr::delCursor(Uint32 idx)
{
    d_cursors.setIdx(idx, 0);

    update_list();
}
/*************************************************************
 * delCursor()
 *************************************************************/
void CursorMgr::delCursor(SdbrCursor *c)
{
    d_cursors.remove(c);
    d_sortCursors.remove(c);
    d_sortValid = false;
    update_list();
}

/*************************************************************
 * update_list()
 *************************************************************/
void CursorMgr::update_list()
{
    d_CursorListCB->Invoke(0, 0);
}

/*************************************************************
 * update()
 *************************************************************/
void CursorMgr::update(void)
{
    /**** For now, always sort ****/
#if 0
    if (!d_sortValid) {
        sortList();
    }
#else
    sortList();
#endif
    d_CursorUpdateCB->Invoke(0, 0);
}

/*************************************************************
 * update()
 *
 * Update a particular cursor...
 *************************************************************/
void CursorMgr::update(SdbrCursor *cursor)
{
    update();

#if 0
    Int32       i = cursor->getIdx(), x;
    Uint32      len = d_cursors.length();
    SdbrCursor *c, *c2;

    if (len < 2) {
        return;
    }

    if (!i) {
        for (x=1; x<len; x++) {
            c = d_cursors.idx(x);
            if (cursor->getTime() <= c->getTime()) {
                break;
            }
        }
    } else {
        if (i < (len-1)) {

        } else {
            c2 = cursor;
            /**** If we're the last element, we can only move down ****/
            for (x=len-2; x>0; x--) {
                c = d_cursors.idx(x);
                if (c->getTime() <= c->getTime()) {
                    break;
                }
                /**** Else, swap ****/
                d_cursors.setIdx(x, 
            c = d_cursors.idx(len-2);

        }
    }
#endif /* 0 */
}

/********************************************************************
 * sortList()
 *
 * Sort d_cursors based on time...
 ********************************************************************/
void CursorMgr::sortList()
{
    Uint32        i, j, len;
    SdbrCursor   *c1, *c2;

    d_sortValid = true;
    len = d_sortCursors.length();

    /**** Sort min-time to max-time ****/
    for (i=0; i<len; i++) {
        for (j=i; j<(len-1); j++) {
            c1 = d_sortCursors.idx(j);
            c2 = d_sortCursors.idx(j+1);

            if (c1->getTime() > c2->getTime()) {
                d_sortCursors.setIdx(j, c2);
                d_sortCursors.setIdx(j+1, c1);
            }
        }
    }
    
}

/********************************************************************
 * getCursors()
 ********************************************************************/
Vector<SdbrCursor> *CursorMgr::getCursors()
{
    return &d_cursors;
}

/********************************************************************
 * getSortCursors()
 ********************************************************************/
Vector<SdbrCursor> *CursorMgr::getSortCursors()
{
    if (!d_sortValid) {
        sortList();
    }
   
    return &d_sortCursors;
}


