/*****************************************************************************
 *                            ShmValChgVector.cc
 * 
 * Author: Matthew Ballance 
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#include "ShmValChgVector.h"
#include <stdlib.h>
#include <memory.h>

ShmValChgVector *ShmValChgVector::prv_AllocList = 0;

/**********************************************************
 * operator new
 **********************************************************/
void *ShmValChgVector::operator new (size_t size)
{
    ShmValChgVector *new_vect = 0;

    if (prv_AllocList) {
        new_vect = prv_AllocList;
        prv_AllocList = prv_AllocList->next;
    } else {
        new_vect = (ShmValChgVector *)malloc(size);
        memset(new_vect, 0, sizeof(ShmValChgVector));
    }
    return new_vect;
}

/**********************************************************
 * operator delete
 **********************************************************/
void ShmValChgVector::operator delete (void *ptr)
{
    ShmValChgVector *vect = (ShmValChgVector *)ptr;

    vect->next = prv_AllocList;
    prv_AllocList = vect;
}

/**********************************************************
 * ShmValChgVector()
 **********************************************************/
ShmValChgVector::ShmValChgVector(Uint32 len) : d_len(len)
{
    if (!blk_store) {
        blk_store = new Vector<ShmDFIOChgBlkData>();
    }
    elem_length = 0;
    blk_cache   = 0;
    init_idx    = 0;
    blk_size    = 1024;
}


/**********************************************************
 * ~ShmValChgVector()
 **********************************************************/
ShmValChgVector::~ShmValChgVector(void)
{
    blk_store->setLength(0);        
}

/**********************************************************
 * append(ShmDFIOChgBlkData)
 **********************************************************/
void ShmValChgVector::append(ShmDFIOChgBlkData *blk)
{
//    blk_size = blk->d_numChanges;
    blk_store->append(blk);    
    elem_length += (blk->d_currChange+1);
}


/**********************************************************
 * idx()
 **********************************************************/
DFIOValChg *ShmValChgVector::idx(Uint32 idx)
{
    ShmDFIOChgBlkData   *blk;
    DFIOValChg    *chg = 0;
    Uint32 i, cnt = 0, tmp_idx = idx, len, blk_try, idx_try;
 
    if (idx >= length()) {
        return 0;
    }

   /**** First, create a 'real' offset from the input
    ****/
    tmp_idx += init_idx;

    blk_try = tmp_idx / blk_size;
    idx_try = tmp_idx % blk_size;

    if (blk_cache && (blk_try == blk_try_cache)) {
        return DFIOValChg_Idx(blk_cache->d_changes, d_len, idx_try);
    }

    blk_cache = blk_store->idx(blk_try);
    blk_try_cache = blk_try;

    if (blk_cache) {
        return DFIOValChg_Idx(blk_cache->d_changes, d_len, idx_try);
    } else {
        return 0;
    }
}

