;;; Some code to help with the conversion to Texinfo format.
;;;
;;; I'm probably the only person interested in this, but what the heck,
;;; I'll include it in the dist anyway.

(global-set-key "\C-c6" 'kf-codeize-ahead)
(global-set-key "\C-c7" 'kf-examplize-region)

(defun kf-examplize-region (b e)
  (interactive "r")
  (setq e (copy-marker e))
  (goto-char b)
  (insert "@example\n")
  (goto-char e)
  (insert "@end example\n"))

(defun kf-codeize-ahead (&optional parg)
  (interactive "P")
  (if parg
      (skip-chars-forward " 	")
    (search-forward "")
    (delete-backward-char 1))
  (insert "@code{")
  (if parg
      (progn 
        (re-search-forward "\\s-")
        (forward-char -1))
    (search-forward "")
    (delete-backward-char 1))
  (insert "}")
  (forward-char -1))
