#include "misc.h"

#include <kdebug.h>

#include <qcanvas.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qvariant.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qdialog.h>

bool getAnimationFromFile( QCanvasPixmapArray &images_array ,QString file, 
                           int w, int h, int n_of_animations, 
                           Qt::Orientation orient, int nw, int nh)
{
    int fw = 0, fh = 0;
    bool scaleit = false;
    int real_w, real_h;

    if ( ( n_of_animations < 0 ) ||
         ( w < 0 ) || ( h < 0 ) ||
         ( nw < 0 ) || ( nh < 0 ) )
     return false;
     
    QImage *pic_realimage = new QImage ( file );
    QPixmap *pix_image;

    QImage pic_image;
    QImage pic_scale_image;
    
    QValueList <QPixmap> temp_pix_array;

    if (orient == Qt::Horizontal) fw = 1;
    else fh = 1;
    
    if ( nw == 0 ) real_w = w;
    else { real_w = nw; scaleit = true; }

    if ( nh == 0 ) real_h = h;
    else { real_h = nh; scaleit = true; }
        
    for (int i = 0; i < n_of_animations; i++)
    {
        pic_image. create( real_w, real_h, 16 );
        if (scaleit)
        {
            pic_scale_image. create( fw*w*i, fh*h*i , 16);
            pic_scale_image = pic_realimage -> copy( fw*w*i, fh*h*i, w, h );
            pic_image = pic_scale_image. smoothScale( real_w, real_h, QImage::ScaleFree);
            pic_scale_image. reset();
        }
        else
        {
            pic_image = pic_realimage -> copy( fw*w*i, fh*h*i, w, h );
        }
        images_array. setImage(i, new QCanvasPixmap( pic_image ) );
        pic_image. reset();
    }
    delete pic_realimage;
    return true;
}

bool makeAnimationMirror( QCanvasPixmapArray &images_array )
{
    int numimg = images_array.count();
    for (int i=0; i < numimg; i++)
        images_array. setImage(i+(numimg), new QCanvasPixmap( images_array.image(i) -> convertToImage(). mirror(true, false) ));
    return true;
}

bool setWall( QString file, QCanvas *canvas )
{
    QPixmap wall( file );
    int cw = canvas -> width() / wall.width();
    if (cw !=0)
        {
            int w = canvas -> width() % wall.width();
            if (w!=0)
                cw++;
        }
    else cw = 1;
    int ch = canvas -> height() / wall.height();
    if (ch != 0)
        {
            int h = canvas -> height() % wall.height();
            if (h != 0)
                ch++;
        }
    else ch = 1;
    
    QPixmap realwall(cw * wall.width(), ch * wall.height());
    for (int rw=0; rw < cw; rw++)
        for (int rh=0; rh < ch; rh++)
        {
            bitBlt(&realwall, rw * wall.width(), rh * wall.height(),
                   &wall, 0, 0, wall.width(), wall.height());
        }
    canvas -> setBackgroundPixmap( realwall );
}
