/*

Protocol definitions for karpski

Brian Costello

*/

typedef struct s_value
{
   long direct_value;
   u_short offset;
   u_char len;
   u_short mask;
   u_char net_order;
   short shift;
} t_value;

typedef struct s_addr
{
   u_char offset;
   char mask[64];
} t_addr;

typedef struct s_listitem
{
   u_char op;		/* 0 = Index, 1 = test for index */
   u_short index;
   char list_desc[30];
   struct s_listitem *next;
} listitem;

typedef struct s_addon
{
   char addon_name[30];
   t_value *value;
   listitem *first_listitem;
   struct s_addon *next;
} addons;


typedef struct s_protocol
{
   u_short protocol_number;
   u_char conn_type;		/* 1 = datagram, 2 = connection */
   t_value *protocol_data_len;
   char protocol_short_name[20];
   char protocol_description[100];
   int outfd;
   u_char active;
   addons *first_addon;
   struct s_protocol *next;
} protocols;

typedef struct s_protolist
{
   u_short frametype;
   char protoname[30];
   long nbytes;
   long npackets;
   struct s_protolist *next;
} protolist;

typedef struct s_ether_protocols
{
   char ether_type_name[30];		/* IPV4 */
   u_short ether_type;			/* 0x0800 and whatnot */
   u_char transportlayer;		/* 1 = yes, contains a protocol */
   t_value *ether_tlen;
   t_value *ether_hlen;
   t_addr *ether_src_addr;
   t_addr *ether_dst_addr;

   u_char ether_protocol_offset;	/* Where is the protocol stored? */

   addons *first_addon;			/* Extra names of items */
   int outfd;				/* Capture file fd */
   u_char active;
   protocols *first_protocol;		/* The protocols defined */
   struct s_ether_protocols *next;
} ether_protocols;

typedef struct s_packet_parse
{
   char *dptr;				/* A pointer to the payload */
   u_short dlen;			/* The length of the payload */
   u_short packetlen;			/* The whole packet length */
   u_short hlen;			/* The transport header len */
   u_short phlen;			/* The protocol header len */
   char frametype[40];
   char src_address[30];		/* Some sort of address */
   char dst_address[30];
   char saddr[18], daddr[18];
   char *addons[20];
   int outfd;				/* THe output file descriptor */
   u_char frame_enc_type;		/* 1 = raw 802.3, 2 = 802.3/802.2, 
   					 * 3 = snap, 4 = ether ii */
   u_char display_proto;		/* This is 1 unless this protocol is
   					 * filtered out - still pass back if
   					 * you want to use the frame for 
   					 * discovery purposes.*/
   long addonvals[20];
   char protostr[40];			/* TCP/IP, ARP, etc */
   char *addonstrs[20];
   int numaddons;
   protocols *protocol_ptr;
} packet_parse;

/* 
The definition of an ethernet 802.3/802.2 frame
Can also be used for Ether-II, Ethernet SNAP and Ethernet-raw packets
*/

struct frame		/* Structure of an 802.3/802.2 frame */
{
   u_char daddr[6];	/* Dest mac */
   u_char saddr[6];	/* Src mac */
   u_short type;	/* Ethernet-II type (rfc 1700) */
   u_char dsap;		/* Dest. SAP */
   u_char ssap;		/* Src SAP */
   u_char cntrl;	/* Control number */
   u_char vendorid[3];	/* Vendor ID - usually same as src mac's vendor */
   u_short type2;	/* 802.3/802.2 type location */
};
         
int read_and_parse_protocols();
void decode_frame(char *, packet_parse *, int);
void free_frame(packet_parse *);
int getaddonval(packet_parse *, char *);
void close_all_frame_captures();
