/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002-2004  Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef CONTEXT_H
#define CONTEXT_H

#include <qvaluelist.h>
#include <qwidget.h>

#include <ktexteditor/document.h>
#include <ktexteditor/view.h>

#include <projectsettings.h>

class QComboBox;
class QVBoxLayout;
class QLineEdit;
class KListEditor;
class KConfig;

struct ContextInfo
{
    QString path;
    uint line;
};

/**
* Widget for displaying source code context of for the given GNU gettext comment.
* The searched paths can be configured using variables @PACKAGE@, @PACKAGEDIR@,
* @CODEROOT@ and @COMMENTPATH@. It requires a KPart implementing KTextEditor interface
* with selections.
*
* @short Class for displaying source code context
* @author Stanislav Visnovsky <visnovsky@kde.org>
*/
class SourceContext : public QWidget
{
    Q_OBJECT
public:
    SourceContext(QWidget* parent=0); 
    
    KBabel::SourceContextSettings settings() const {return _settings;}
    void setSettings(const KBabel::SourceContextSettings& settings);
    
    void saveSettings(KConfig* config);
    void restoreSettings(KConfig* config);

public slots:
    /**
     * Try to find the corresponding file and load it to this widget.
     * @param packageDir	path of the package, where to find the source file
     * @param packageName	name of the package, where to find the source file
     * @param gettextComment	comment string with context as generated by xgettext (can start with #:)
     */
    void setContext( const QString& packageDir, const QString& packageName, const QString& gettextComment );

private:
    QValueList<ContextInfo> resolvePath( const QString& packageDir, const QString& packageName, const QString& gettextComment);
    bool loadPart();
    
    KTextEditor::Document* _part;
    KTextEditor::View* _view;
    QComboBox *_referenceCombo;
    QVBoxLayout *_layout;
    
    QValueList<ContextInfo> _referenceList;
    
    KBabel::SourceContextSettings _settings;
private slots:
    void updateToSelected(int index);
};

/**
* This class implements preference widget for source context
*
* @short Class for setting preferences for source context
* @author Stanislav Visnovsky <visnovsky@kde.org>
*/
class SourceContextPreferences : public QWidget
{
    Q_OBJECT
public:
    SourceContextPreferences(QWidget* parent=0); 
    virtual ~SourceContextPreferences();
    
    void mergeSettings(KBabel::SourceContextSettings& settings) const;
    void setSettings(const KBabel::SourceContextSettings& settings);
    void defaults();

    virtual bool eventFilter(QObject *, QEvent*);

private:
    QLineEdit* _coderootEdit;
    KListEditor* _pathsEditor;
};

#endif // CONTEXT_H
