/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdebug.h>

#include "DGuiView.h"
#include "DGuiItem.h"

DGuiItem::DGuiItem(DGuiView * parent, int id) : DItem(id)
{
    // dangerous ? not if every view manages its items/children properly
    m_parent = parent;
}

DGuiItem::~DGuiItem()
{
}

DDataItem* DGuiItem::data() const
{
    if (!m_parent)
    {
	kdWarning()<<"bug in DGuiItem::data"<<endl;
	return NULL;
    }

    return m_parent->dataItem(Id());
}

const DDataItem* DGuiItem::data(int id) const
{
    if (!m_parent)
    {
	kdWarning()<<"bug in DGuiItem::data"<<endl;
	return NULL;
    }

    return m_parent->dataItem(id);
}

