/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DGUIVIEW_H
#define _DGUIVIEW_H

#include "../datastruct/DItem.h"
#include "../datastruct/DBase.h"

class DDataControl;
class DDataItem;
/**
 * @short Base class for mindmap views
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DGuiView : public DBase
{
    public:
	DGuiView(QWidget* parent=0, const char* name=0);
	virtual ~DGuiView();

	void setDataTree( DDataControl *);
	DDataControl * dataTree() const;

	DDataItem* dataItem(int);
	inline void setReadWrite(bool val=true) { m_readWrite = val; }

    private:
	DDataControl * m_data;

    protected:
	// use the following in subclasses for connecting 
	// and disconnecting the view to and from the data
	// implement in subclasses because it makes problems with QObject
	virtual void plug()   = 0;
	virtual void unplug() = 0;

	/// indicates if the view is read-only
	bool m_readWrite;
};

#endif // _DGUIVIEW_H
