/***************************************************************************
 *   Copyright (C) 2005 by Thomas Nagy                                     *
 *   tnagy256@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qspinbox.h>

#include <kdebug.h>
#include <kcombobox.h>
#include <kcolorbutton.h>
#include <klineedit.h>
#include <klocale.h>
#include <kfontrequester.h>

#include "DDataControl.h"
#include "docsettings.h"
#include "docsettingsdlg.h"

docsettingsdlg::docsettingsdlg( QWidget*parent,DDataControl* data ) : 
	KDialogBase(parent, 0, true, i18n("Edit the document properties"), Ok|Apply|Cancel)
{
	m_data = data;
	m_content = new docsettings(this);
	setMainWidget(m_content);

	connect(this, SIGNAL(applyClicked()), this, SLOT(slotApply()));
	connect(this, SIGNAL(okClicked()), this, SLOT(slotApply()));

	m_content->fname->setText( m_data->m_fname );
	m_content->sname->setText( m_data->m_sname );
	m_content->pixSize->setValue( m_data->m_pixSize );

	m_content->col_background->setColor( m_data->m_col_background );
	m_content->col_link->setColor( m_data->m_col_link );
	m_content->col_ref->setColor( m_data->m_col_ref );
	m_content->canvasFont->setFont( m_data->m_canvasFont );

	m_content->picturesOnCanvas->setChecked( m_data->m_picturesOnCanvas );
	m_content->showDirectionSize->setValue( m_data->m_showDirectionSize );

	m_content->linkStyle->setCurrentItem( m_data->m_linkstyle );
}

docsettingsdlg::~docsettingsdlg()
{
	delete m_content;
}

void docsettingsdlg::slotApply()
{
	m_data->m_fname = m_content->fname->text();
	m_data->m_sname = m_content->sname->text();

	m_data->m_pixSize = m_content->pixSize->value();

	m_data->m_col_background = m_content->col_background->color();
	m_data->m_col_link = m_content->col_link->color();
	m_data->m_col_ref = m_content->col_ref->color();

	m_data->m_canvasFont = m_content->canvasFont->font();
	
	m_data->m_picturesOnCanvas = m_content->picturesOnCanvas->isChecked();
	m_data->m_showDirectionSize = m_content->showDirectionSize->value();

	m_data->m_linkstyle = m_content->linkStyle->currentItem();

	m_data->updateSettings();
}

#include "docsettingsdlg.moc"


