/***************************************************************************
                          kfocuslogentry.cpp  -  description
                             -------------------
    begin                : Fri Aug 17 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfocuslogentry.h"

KFMLog::KFMLog()
	: QObject()
{
	position_ = -1;
	date_ = QDate::currentDate();
}

KFMLog::KFMLog(const KFMLog* entry)
	: QObject()
{
	position_ = -1;
	date_ = entry->date();
	body_ = entry->body();
}


KFMLog::~KFMLog(){
	deleted();
}

/** Form a DOM element from the entry */
QDomElement KFMLog::domElement(QDomDocument* dDoc){
	QDomElement eEntry = dDoc->createElement("entry");
	
		QDomElement eDate = dDoc->createElement("date");
			eDate.setAttribute("year", date().year());
			eDate.setAttribute("month", date().month());
			eDate.setAttribute("day", date().day());
			eEntry.appendChild(eDate);

		QDomElement eBody = dDoc->createElement("body");			
			eBody.appendChild(dDoc->createTextNode(body()));
			eEntry.appendChild(eBody);
		
		return eEntry;
}

/** Setup the entry according to the DOM element */
void KFMLog::domElement(QDomElement eEntry){
	QDomNode n = eEntry.firstChild();
	while (!n.isNull()) {
		QDomElement e = n.toElement();
		if (!e.isNull()) {
			if (e.tagName() == "date") {
				QString year = e.attribute("year","1970");
				QString month = e.attribute("month", "12");
				QString day = e.attribute("day", "26");
				date(QDate(year.toInt(), month.toInt(), day.toInt()));
			}
			else if (e.tagName() == "body") {
				QDomText t = e.firstChild().toText();
				if (!t.isNull())
					body(t.data());
			}
		}
		
		n = n.nextSibling();
	}
}


/** Date for the entry */
QDate KFMLog::date() const{
	return date_;
}

/** Set the date */
void KFMLog::date(QDate date){
	if (date != date_) {	
		date_ = date;
	
		emit dateChanged(this);
		emit contentsChanged();
	}
}


/** Date in string form */
QString KFMLog::dateString() const{
	return QString::number(date().year())
					+ "-" + date().monthName(date().month())
					+ "-" + QString::number(date().day())
					+ "  " + date().dayName(date().dayOfWeek());
}

/** Get the body of the entry */
QString KFMLog::body() const{
	return body_;
}

/** Set the body of the entry */
void KFMLog::body(QString body){
	body_ = body;
	contentsChanged();
}


/** Compare against another entry */
bool KFMLog::operator<(const KFMLog & other) const{
	if (date() < other.date())
		return true;
		
	if (date() == other.date() && position() < other.position())
		return true;
		
	return false;
}

/** Compare against another entry */
bool KFMLog::operator==(const KFMLog & other) const{
	return (date() == other.date() && position() == other.position());
}
