/***************************************************************************
                          kfvdate.cpp  -  description
                             -------------------
    begin                : Mon Sep 24 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfvdate.h"
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include "kdatedialog.h"

KFVDate::KFVDate(QWidget *parent, const char *name ) : QWidget(parent,name) {
	date_ = QDate::currentDate();
	
	setDisabled(true);
	createWidgets();
}
KFVDate::~KFVDate(){
}

///////////////////////////////////////////////////////////////////////
// Public members


/** Specify a new date for the view */
void KFVDate::date(const QDate& date){
	date_ = date;
	
	leDate_->setText(date_.toString());
}


//////////////////////////////////////////////////////////////////////
// Private members

/** Create child widgets for the view */
void KFVDate::createWidgets(){
	QHBoxLayout* hbl = new QHBoxLayout(this);
		hbl->setSpacing(2);
		hbl->addWidget(leDate_ = new QLineEdit(date_.toString(), this));
			leDate_->setReadOnly(true);
		hbl->addWidget(pbEdit_ = new QPushButton("Edit", this));
			connect(pbEdit_, SIGNAL(clicked()), this, SLOT(onPbEditClicked()));
}


/** Slot to receive clicks of the edit pushbutton */
void KFVDate::onPbEditClicked(){
	KDateDialog dlg;
	
	dlg.date(date_);
	
	if (dlg.exec()) {
		/* Update the lineedit displaying the current date */
		leDate_->setText(dlg.date().toString());
		
		/* Write the new current date */
		date_ = dlg.date();
		
		/* Let listeners know */
		emit dateChanged(date_);
	}
}
