/***************************************************************************
                          kfxenddate.cpp  -  description
                             -------------------
    begin                : Fri Sep 7 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfxenddate.h"

#include "kfmenddate.h"

KFXEndDate::KFXEndDate(QDomDocument* doc, KFMEndDate* endDate){
	doc_ = doc;
	endDate_ = endDate;
}

KFXEndDate::~KFXEndDate(){
}
	
QString KFXEndDate::xmlTag(){
	return QString("enddate");
}
	
QDomElement KFXEndDate::domElement() const{
	QDomElement element = doc_->createElement(xmlTag());
		element.setAttribute("type", endDate_->type());
		element.setAttribute("year", endDate_->date().year());
		element.setAttribute("month", endDate_->date().month());
		element.setAttribute("day", endDate_->date().day());
		return element;
}


void KFXEndDate::domElement(QDomElement element){
	KFMEndDate::Type type
		= (KFMEndDate::Type)(element.attribute("type",QString::number(KFMEndDate::NotADate)).toInt());
		endDate_->type(type);
	
	
	int year = element.attribute("year",QString::number(QDate::currentDate().year())).toInt();
	int month = element.attribute("month",QString::number(QDate::currentDate().month())).toInt();
	int day = element.attribute("day",QString::number(QDate::currentDate().day())).toInt();
		endDate_->date(QDate(year,month,day));
}
