/* -*- c++ -*-
 *
 * giftdownload.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_giftdownload_h__
#define __libkmldonkey_giftdownload_h__

#include <qstring.h>
#include <kdebug.h>

#include "infoiface.h"
#include "giftmessage.h"

/*
class GiftSourcesInfo : public InfoInterface
{
public:
    GiftSourcesInfo() : InfoInterface() {}
    ~GiftSourcesInfo() {}
};
*/

class GiftDownloadInfo : public InfoInterface
{
public:

    /**
     * States the GiftDownloadInfo could have.
     */
    enum enumStates {
        Unknown = 0,
        Active,
        Paused,
        Completed
    };

    /**
     * Constructor.
     */
    GiftDownloadInfo(GiftMessage* message);
    /**
     * Destructor.
     */
    ~GiftDownloadInfo();

    /**
     * Update the content of this GiftDownloadInfo-instance.
     */
    void update(GiftMessage* message);

    /**
     * The file being transfered, only the filename, no path.
     */
    QString filename() { return m_file; }
    /**
     * The hash of the file. This can be used to find exactly similar files so
     * that multiple sources can be used for a download. (Again, if supported
     * by the protocol). Use this value for 'grouping' files.
     */
    QString hash() { return m_hash; }
    /**
     * The size of the file in bytes.
     */
    long size() { return m_size; }
    /**
     * Number of bytes transmitted.
     */
    long transmit() { return m_transmit; }
    /**
     * Indicating whether or not the file is explicitly shared. Only for UPLOADs.
     */
    bool isShared() { return m_isshared; }
    /**
     * Active, Paused or Completed.
     */
    enumStates state() { return m_state; }

private:
    QString m_file;
    QString m_hash;
    enumStates m_state;
    long m_size;
    long m_transmit;
    bool m_isshared; // only on upload
};

#endif
