#include "knap_chatmanagerpanel.h"
#include <qlayout.h>  
#include <qlabel.h>  

#include "support_funcs.h"

#include <iostream>

KNAP_ChatManagerPanel::KNAP_ChatManagerPanel(QWidget *parent,const char *name)
   : QTabWidget(parent,name)
   //: KNAP_ButtonTabbar(parent,name)
{
   chans.setAutoDelete(true);

//  setFrameStyle( QFrame::Panel | QFrame::Sunken );

   // open the local chat win - is always there
   openChatWindow("Console",false);
}
KNAP_ChatManagerPanel::~KNAP_ChatManagerPanel()
{
}

void KNAP_ChatManagerPanel::setOffline()
{
   // for each channel - write an error message saing offline
   // and clear the userlist
   KNAP_ChanPanel *chat;
   
   for(int i=0;i<chans.count();i++)
  {
     ChatData * d = chans.at(i);
     if(d!=0)
     {
	chat = (KNAP_ChanPanel *)d->wid;
	if(chat && d->name != "Console")
	{
//          chan->writeString(i18n("-------- Offline ---------"),
//		KNAP_ChanPanel::MessageError);  
//	  if(chan->isUserlistShown()) chan->clearUserList();
          chat->setOffline();
	}
     }
  }  
}

KNAP_ChanPanel * KNAP_ChatManagerPanel::openChatWindow(const char *name,bool showuserlist)
{
//   if(findWidget(name)!=0) return 0; // only allow 1 of each
   if(showuserlist)
   {
     if(findChanWindow(name)!=0) return 0; // only allow 1 of each
   }
   else 
   {
     if(findChatWindow(name)!=0) return 0; // only allow 1 of each
   }
   
   KNAP_ChanPanel * chan = new KNAP_ChanPanel(this,name);

   addTab(chan,name); // TODO can add icon as well so peeps can see what type we are

   chan->showUserlist(showuserlist);
   chan->setWhoAmI(whoami);
   //chan->setEchoMode(!showuserlist);

   return chan;
}
void KNAP_ChatManagerPanel:: closeChatWindow(const char *name)
{
  KNAP_ChanPanel * chan = findWidget(name);
  if(chan) remTab(chan);
}

void  KNAP_ChatManagerPanel::addTab(QWidget *p, const QString &s)
{
  chans.append(new ChatData(s,p));
  QTabWidget::addTab(p,s);
}
void  KNAP_ChatManagerPanel::remTab(QWidget *p)
{
   ChatData * d = 0;

  for(int i=0;i<chans.count();i++)
  {
     ChatData * d = chans.at(i);
     if(d && d->wid == p)
     {
        chans.removeRef(d);
	break;
     }
  }  
  QTabWidget::removePage(p);
}
/*
KNAP_ChanPanel * KNAP_ChatManagerPanel::findWidget(const QString &n)
{
  for(int i=0;i<chans.count();i++)
  {
     ChatData * d = chans.at(i);
     if(d && n.compare(d->name)==0)
	return (KNAP_ChanPanel *)d->wid;
  }
  return 0;
}
*/
void KNAP_ChatManagerPanel::writeChannel(const QString &data,
      KNAP_ChanPanel::MessageType type)
{
   QString tmp = data;
   QString chan = extractString(tmp);
   writeChannel(chan,tmp,type);
}
void KNAP_ChatManagerPanel::writeChannel(const QString &channame,QString &text,
      KNAP_ChanPanel::MessageType type)
{
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);
  if(chan==0) chan = (KNAP_ChanPanel *)(chans.at(0))->wid;

  if(chan) chan->writeString(text,type);
}
void KNAP_ChatManagerPanel::setChannelTopic(QString &data)
{
  QString channame = extractString(data);
   
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);
  
  //if(chan) chan->addUserMessage(text); //writeString(text,type);
  if(chan) chan->setTopic(data); 
}
void KNAP_ChatManagerPanel::writeChannelActionMessage(const QString &data)
{
  QString tmp = data; 
  QString channame = extractString(tmp);
   
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);
//  if(!chan) chan = findWidget("Console");
  if(chan) chan->addUserActionMessage(tmp);
}
void KNAP_ChatManagerPanel::writeChannelMessage(const QString &data)
{
  QString tmp = data; 
  QString channame = extractString(tmp);
   
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);
  
  if(chan) chan->addUserMessage(tmp);
}
// sends a user IM message
void KNAP_ChatManagerPanel::writeUserMessage(const QString &data)
{
  QString tmp = data; 
  QString username = extractString(tmp);
   
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(username);
  if(!chan) chan = findWidget("Console");
  if(chan) chan->addUserMessage(data);
}

void KNAP_ChatManagerPanel::clearChannel(const QString &channame)
{
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);
  if(chan!=0) chan->clear();
}

void  KNAP_ChatManagerPanel::writeError(QString &text)
{
  KNAP_ChanPanel * chan = (KNAP_ChanPanel *)currentPage();
  // if this isnt the current tab we can get 0 - get the first and use it
  if(chan==0) chan = (KNAP_ChanPanel *)(chans.at(0))->wid;
  chan->writeString(text,KNAP_ChanPanel::MessageError);
}
void KNAP_ChatManagerPanel::userJoined(const QString &data,bool notify)
{
   QString tmp = data;
   QString channame = extractString(tmp);

   KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);

   if(chan) chan->addUser(tmp,notify); 
}
void KNAP_ChatManagerPanel::userLeft(const QString &data)
{
   QString tmp = data;
   QString channame = extractString(tmp);

   KNAP_ChanPanel * chan = (KNAP_ChanPanel *)findWidget(channame);

   if(chan) chan->remUser(tmp); 
}
KNAP_ChanPanel * KNAP_ChatManagerPanel::findWidget(const QString &n)
{
  for(int i=0;i<chans.count();i++)
  {
     ChatData * d = chans.at(i);
//     if(d && n.compare(d->name)==0)
     if(d && n.contains(d->name,false)!=0 && n.length()==d->name.length())
	return (KNAP_ChanPanel *)d->wid;
  }
  return 0;
}
KNAP_ChanPanel * KNAP_ChatManagerPanel::findChanWindow(const QString &n)
{
  for(int i=0;i<chans.count();i++)
  {
     ChatData * d = chans.at(i);

//     if(d && n.compare(d->name)==0 && // assumes that channels have the userlist
     if(d && n.contains(d->name,false)!=0 && // assumes that channels have the userlist
	   d->wid && ((KNAP_ChanPanel *)d->wid)->isUserlistShown()) // &&
	  // d->name.length() == n.length())
     {
	return (KNAP_ChanPanel *)d->wid;
     }
  }
  return 0;
}
KNAP_ChanPanel * KNAP_ChatManagerPanel::findChatWindow(const QString &n)
{
  for(int i=0;i<chans.count();i++)
  {
     ChatData * d = chans.at(i);

     if(d && n.contains(d->name,false)!=0 && // assumes that chat doesnt show userlist
	   d->wid && !((KNAP_ChanPanel *)d->wid)->isUserlistShown()) // &&
//	   d->name.length() == n.length())
     {
	return (KNAP_ChanPanel *)d->wid;
     }
  }
  return 0;
}
/*
KNAP_ChanPanel * findWidgetWindow(const QString name)
{

}
*/
