/***************************************************************************
                          napsterdownload.cpp  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterdownload1.h"

#include "support_funcs.h"

#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/tftp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/un.h>

#include <signal.h>

#include <stdio.h>
#include <stdlib.h>
#include <iostream> // X
using namespace std;

#include <ksock.h>

static void sigpipe_handler(int)
{
  cerr<<"dload sigpipe caught!!\n"<<flush;
  return;
}
NapsterDownload1::NapsterDownload1(KSocket *s,const char *filename,const char *user,
         long size,int speed,const char *dest)
: NapsterTransfer(0,0,filename,user,speed,dest,true)
{
   _file=-1;
   _sock=-1;

  sock = s;
   
   _header_pos=0;
   _gotheader=false;

   _totalsize = size;


   _listener=sock->socket(); // TODO not needed!!!!!!!!!!!!!
   _sock = sock->socket();

   _connected = true;

   cerr<<"NapsterDownload1::NapsterDownload1(): type2 : " << filename  <<
      " listener: " << _listener << " size: " << _totalsize << endl;
}

NapsterDownload1::NapsterDownload1(unsigned long ip,int port,const char *filename,const char *user,
         int speed,const char *dest)
: NapsterTransfer(ip,port,filename,user,speed,dest,true)
{
   _file=-1;
   _sock=-1;

  sock = 0;
   
   _header_pos=0;
   _gotheader=false;


   _listener=-1;

   QString s="";
   struct in_addr in;

   //  if(_napster)
   //  {
   in.s_addr = ip; //_napster->ipv4_addr();
   s=inet_ntoa(in);
   //  }   
   cerr<<"NapsterDownload1::NapsterDownload1(): " << s << " : "<<port<<endl<<flush;
   cerr<<"NapsterDownload1::NapsterDownload1(): raw ip was:" << ip << endl;
}

bool NapsterDownload1::waitData()
{

   fd_set fdsr,fdse;
   struct timeval tm;
   int timeout = 0;

    // wait for some data
   do 
   {
      if(_terminate) return false; // got a terminate

      FD_ZERO(&fdsr);
      FD_SET(_sock,&fdsr);
      FD_ZERO(&fdse);
      FD_SET(_sock,&fdse);

      tm.tv_sec=1;
      tm.tv_usec=0;

      timeout++;

      if(_timeoutval>0 && timeout>=60*_timeoutval)
      {
	 // no data has been read for _timeoutval mins for the header

         cerr<<"NapsterDownload1::waitData(): wait timeout occured "<<endl;

	 down();
	  _status=DL_TIMEOUT;
	 up();

	 return false;
      }
   }
   while(select(_sock+1,&fdsr,NULL,&fdse,&tm)<=0);

   // check if data or a terminate
   if(FD_ISSET(_sock,&fdse))
   {
      down();
      _status=DL_ERROR;
      up();
      
      cerr<<"NapsterDownload1::waitData(): error doing 'read' " << endl;

      return false;
   }

   return true;
}

bool NapsterDownload1::init()
{
   fd_set fdsr,fdse;
   struct timeval tm;
   int timeout = 0;

   if(_terminate) return true;

   int l;

   sock = new KSocket(_address,_port);

   _sock = sock->socket();
   if(_sock==-1) 
   {
#ifdef DEBUG_1
      cerr<<"dl: no socket!!\n"<<flush;
#endif
      return false;
   }
   
   char c;

   // wait for the data or a timeout
   if(waitData()==false) return false;
   
   if(recv(_sock,&c,1,0)!=1)
   {
      down();
       _status=DL_ERROR;
      up();

      cerr<<"NapsterDownload1::init(): error doing 'read' " << endl<<flush;

      return false;
   }

   // calc resume pos
   down();
     _readsize = getFileSize(_destname);
   up();

   QString   s = QString(_user) + QString(" \"") + _filename + QString("\" ")
      + QString().setNum(_readsize); // size ( for resumes )

   cerr<<"NapsterDownload1::init(): will send 'GET: " << s  << "'" << endl;
   
   l = send(_sock, "GET", 3, 0);

   if(l<3) 
   {
      down();
      _status=DL_ERROR;
      up();

      cerr<<"NapsterDownload1::init(): error doing GET send." << endl;

      return false;
   }

   l=s.length();
   l = send(_sock, s, l, 0);

   if(l<0) 
   {
      down();
      _status=DL_ERROR;
      up();

      cerr<<"NapsterDownload1::init(): error doing length send" << endl;

      return false;
   }
   cerr<<"NapsterDownload1::init(): initilise complete\n";

   _connected=true;

   return true;
}

bool NapsterDownload1::init2() // TODO NOT NEDED!!!!!!!!!!!!!!
{

  return true;
}
NapsterDownload1::~NapsterDownload1()
{
   if(_file!=-1) close(_file);
   if(sock) delete sock;
}

bool NapsterDownload1::processDownload()
{
   if(!_connected) 
   {
#ifdef DEBUG_1
      cerr<<"Not connected idiot\n"<<flush;
#endif
      return false;
   }

   bool val=false;

   if(!_gotheader) 
   {
      if(_listener!=-1) val = header2();
      else val = header();
   }
   else val = data();


   return val;
}

bool NapsterDownload1::header()
{
   int n;
   fd_set fdsr,fdse;
   struct timeval tm;
   int timeout = 0;

   // getting the header data still
   char c;

   // wait for a byte or a terminate
   do 
   {
      if(_terminate) return false; // got a terminate

      FD_ZERO(&fdsr);
      FD_SET(_sock,&fdsr);
      FD_ZERO(&fdse);
      FD_SET(_sock,&fdse);

      tm.tv_sec=1;
      tm.tv_usec=0;

      timeout++;

      if(_timeoutval>0 && timeout>=60*_timeoutval)
      {
	 // no data has been read for _timeoutval mins for the header
#ifdef DEBUG_1
	 cerr<<"timeout occured "<<endl<<flush;
#endif
	 down();
	 _status=DL_TIMEOUT;
	 up();

	 return false;
      }
   }
   while(select(_sock+1,&fdsr,NULL,&fdse,&tm)<=0); // check if data or a terminate

   if(FD_ISSET(_sock,&fdse))
   {
      down();
      _status=DL_ERROR;
      up();

#ifdef DEBUG_1
      cerr<<"Xdl+: error doing header read " << endl<<flush;
#endif

      return false;
   }


   n = recv(_sock, &c, 1, 0);

   if(n<0) {
#ifdef DEBUG_1
      cout<<"hdr read error\n"<<flush;
#endif
      if(_header_pos!=-1) {
	 _buffer[_header_pos]=0;
#ifdef DEBUG_1
	 cerr<<"Got the errored header of: "<<_buffer<<endl<<flush;
#endif

      }
      return false;
   }
   if(n==0) {
#ifdef DEBUG_1
      cout<<"no data read in dload header\n"<<flush;
#endif
      return false;
   }

   // if end of size - end of the header??
   if(c<'0' || c>'9') {  // -1 (255)

#ifdef DEBUG_2
      if(c=='\0') cerr<<"********* end of header was a null!!!!\n"<<flush;
#endif
      // end of header
      _buffer[_header_pos]='\0';
      _gotheader=true;
      char *tmp;

//#ifdef DEBUG_1
      cerr<<"NapsterDownload1::header(): Got the header of: "<<_buffer<<endl<<flush;
//      cerr<<"HEX: [ ";
//      for(int x=0;x<_header_pos;x++) cerr<<(int)_buffer[x]<<" ";
//      cerr<<"]\n"<<flush;
//#endif
      // get the size from the header
      tmp=_buffer;


      if(_header_pos==0)
      {
	 // we got data straight away that isn't the filesize
	 _buffer[0]=c;
	 _header_pos = recv(_sock,&_buffer[1],100,0);
	 if(_header_pos<0) 
	 {
#ifdef DEBUG_1
	    cerr<<"read error in download error reason code\n"<<flush;
#endif
	    return false;
	 }
	 _buffer[_header_pos + 1] = '\0';
#ifdef DEBUG_1
	 cerr<<"got error reason: "<<_buffer<<endl<<flush;
#endif
	 down();
           _status = DL_REMOTEERROR;
	 up();
	 //--------------------------------------------
	 //       if(strstr(tmp,"INVALID")==NULL) {
	 //           sendMsg(DL_ERROR);
	 //
	 //           return false;
	 //       }
	 // TODO : other errors?????????????????????
	 //--------------------------------------------

	 return false;
      }

      // open the file
      setDownloadName(_destname); // **** true -  also truncate the file
      if(_file==-1) {
#ifdef DEBUG_1
	 cerr<<"couldn't open file "<<_destname<<endl<<flush;
#endif
	 down();
	 _status=DL_NOLOCALFILE;
	 up();
	 return false;
      }

      if(_file!=-1 && _readsize!=0) 
      { // we have stuff in the file -> append
	 lseek(_file,_readsize,SEEK_SET); // go to the end
      }

      // this byte is data -> send there
      write(_file,&c,1); // the first byte

      down();
      _readsize++; // add to whats already read ( if any )
      _totalsize=atoi(_buffer);
#ifdef DEBUG_1
      cerr<<"total size of: "<<_totalsize<<endl<<flush;
#endif
      time(&_starttime); // set the start time
      up();
   }
   else {
      // part of the size header
      if(_header_pos!=-1) {
	 _buffer[_header_pos]=c;
	 _header_pos++;
      }
      if(c=='\0') _header_pos=-1; // ignore the restb of the header??

      // if we've got something 'INVALID' or 'NOT' -> an error -> no download will happen

   }

   return true;
}

bool NapsterDownload1::header2()
{
  long startfrom=0;

  // open the file
  setDownloadName(_destname);
  if(_file==-1) 
  {
      cerr<<"NapsterDownload::header2(): couldn't open file "<<_destname<<endl<<flush;
      down();
        _status=DL_NOLOCALFILE;
      up();

      return false;
  }


  if(_file!=-1)  // TODO use Qt stuff
  {
      struct stat statbuff;
      if(fstat(_file,&statbuff)==0) 
      {
        startfrom=statbuff.st_size;
        cerr<<"NapsterDownload::header2():resuming download of "
	   <<_destname<<" at "<<startfrom<<endl<<flush;
        startfrom=lseek(_file,startfrom,SEEK_SET); // go to the end
        if(startfrom<0) startfrom=0;
      }
  }

  // send where to start from

  QString s;

  s = s.setNum(startfrom);


  if(send(_sock,s,s.length(),0)<0)
  {  // send start pos

       down();
         _status=DL_ERROR;
       up();

       cerr<<"NapsterDownload::header2(): Xdl6: error doing send " << endl<<flush;

       return false;
  }
  down();
    _readsize=startfrom;  // how much has already been read

    time(&_starttime); // set the start time

    _gotheader=true; // mark header as finished
  up();

  return true;
}

bool NapsterDownload1::data()
{
   int n;
   int timeout=0;
   fd_set fdsr,fdse;
   struct timeval tm;

   do 
   {
      if(_terminate) return false; // got a terminate

      FD_ZERO(&fdsr);
      FD_SET(_sock,&fdsr);
      FD_ZERO(&fdse);
      FD_SET(_sock,&fdse);

      tm.tv_sec=1;
      tm.tv_usec=0;

      timeout++;

      if(_timeoutval>0 && timeout>=60*_timeoutval)
      {
	 // no data has been read for _timeoutval mins for the header
#ifdef DEBUG_1
	 cerr<<"data timeout occured "<<endl<<flush;
#endif
	 down();
	 _status=DL_TIMEOUT;
	 up();

	 return false;
      }

   }
   while(select(_sock+1,&fdsr,NULL,&fdse,&tm)<=0); // check if data or a terminate

   if(FD_ISSET(_sock,&fdse))
   {
      down();
      _status=DL_ERROR;
      up();

      cerr<<"Xdl2m: error doing 'read data' " << endl<<flush;

      return false;
   }


   n = recv(_sock, _buffer, 2048, 0);
   if (n==0) 
   { // finished download  ( or closed connection )
      _connected=false;

      if(sock) delete sock;
      sock = 0;
      if(_file!=-1) close(_file);
      _file=-1;
#ifdef DEBUG_1
      cerr<<"finished download sz: "<<_readsize << " of "<<_totalsize<<endl<<flush;
#endif
      return false;
   }
   else if(n<0) {
#ifdef DEBUG_1
      cerr<<"read error in download\n"<<flush;
#endif
      return false;
   }
   else {
      write(_file,_buffer,n);

      down();
      _readsize+=n;
      _status=DL_DOWNLOADING;
      up();
   }
   return true;
}

bool NapsterDownload1::setDownloadName(const char *path,bool truncate)
{
   int flags=O_WRONLY|O_CREAT;


   if(_file!=-1) return false; // file has already been set

   if(truncate) flags|=O_TRUNC;

   _file=open(path,flags,0644);  // 0664 open and set to rw-rw-r-- ( octal )

   return (_file!=-1);
}

bool NapsterDownload1::start(int _listen,long sz)
{
   cerr << "NapsterDownload1::start()\n";
   // set that we are initialising
   _status=DL_INIT;

   cerr<<"NapsterDownload1::start(): created thread for "<<_filename<<endl<<flush;

   // start the thread going
   run();

   return true;
}

void NapsterDownload1::run_method()
{
   cerr<<"NapsterDownload1::run_method(): starting download thread\n";

   //  signal(SIGPIPE,SIG_IGN);
   signal(SIGPIPE,sigpipe_handler);

   down();
   _status=DL_INIT;
   up();

   if(_listener==-1)
   {
      if(!init()) 
      {
	 down();
	 if(_status!=DL_TIMEOUT) _status=DL_NOCONNECT;
	 up();
	 cerr<<"NapsterDownload1::run_method(): init error\n";
	 return;
      }
   }
   // dload2 init
   else if(!init2())
   {
      down();
      if(_status!=DL_TIMEOUT) _status=DL_NOCONNECT;
      up();
      cerr<<"NapsterDownload1::run_method(): init2 error\n";
      return;
   }
   // while we can - process the download - until user terminate
   // or no read
   while(!_terminate && processDownload()) { }

   down();
   if(_terminate) _status=DL_KILLED;
   else if(_status==DL_NOLOCALFILE || _status==DL_REMOTEERROR ||
	 _status==DL_TIMEOUT) {  } // error has been set already
   else if (_readsize>=_totalsize-2048) _status=DL_FINISHED;
   else  _status=DL_ERROR;           // only partial download????
   up();

   cerr<<"NapsterDownload1::run_method(): finished download thead\n";

   return;
}
