/***************************************************************************
                          tabbox.h  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABBOX_H
#define TABBOX_H

#include <qvbox.h>
#include "accel.h"

class QTabWidget;
class resource;

/**
  *@author Troy Corbin Jr.
  */

class TabBox : public QVBox
{
	Q_OBJECT
	public:
								TabBox( resource *rsrc=0 );
		virtual			~TabBox();
		void				keyPressEvent( QKeyEvent* );
		void				addTab( QWidget *child, const QString &caption );
		void				removeTab( QWidget *child, bool deleteChild=FALSE );
		bool				isChild( QWidget *child );
		void				showTab( QWidget *child );
		void				changeCaption( QWidget *child, const QString &caption );
		int					count( void );

	signals:
		void				newTabBox( TabBox* );
		void				saveTabGeometry( const QString&, const QSize& );
		void				focus( const QChar& );

	protected slots:
		void				changeMyCaption( QWidget *child );

								/**
									This removes and deletes a Tab if it's a child of this widget.
									Never call this directly; Only with a Signal!
								*/
		void				destroyChild( void );

	private:
		QTabWidget	*myTabs;
		Accel				*myAccel;
		resource		*myResource;
};

#endif
