h36364
s 00000/00000/00204
d D 1.11 00/03/07 11:48:03 nitehawk 12 11
c Turn on SCCS flag
cC
cK50458
cX0xa1
e
s 00000/00000/00204
d D 1.10 00/03/06 22:42:13 nitehawk 11 10
c Delete: lib/vm/dbmemops.c
cK32855
cPBitKeeper/deleted/.del-dbmemops.c
e
s 00000/00000/00204
d D 1.9 00/03/06 18:41:45 nitehawk 10 9
c Rename: lib/db/dbmemops.c -> lib/vm/dbmemops.c
cK28359
cPlib/vm/dbmemops.c
e
s 00001/00000/00203
d D 1.8 00/02/24 19:04:14 nitehawk 9 8
c Add include for memory.h
cC
cK56284
e
s 00003/00003/00200
d D 1.7 00/02/24 18:36:36 nitehawk 8 7
c Convert memory calls to use wrapper functions
cK54584
e
s 00004/00000/00199
d D 1.6 00/02/22 19:05:07 nitehawk 7 6
c Add mapping size tracking
cC
cK50748
e
s 00001/00001/00198
d D 1.5 00/02/19 17:54:56 nitehawk 6 5
c Move lib specific include files
cC
cK37333
e
s 00001/00001/00198
d D 1.4 00/02/18 11:43:41 nitehawk 5 4
c Fix bug in aligned mapping where a current mapping can be reused
cC
cK36975
e
s 00001/00002/00198
d D 1.3 00/02/17 18:42:48 nitehawk 4 3
c Fix calculations in mapping to determine if a block contains
c the desired mapping
cC
cK36765
e
s 00168/00006/00032
d D 1.2 00/02/17 18:20:26 nitehawk 3 2
c Finished code for mmapblockaligned
c added unmapfreeblocks, mapfree, and closemapfile
cK36734
e
s 00038/00000/00000
d D 1.1 00/02/17 12:02:39 nitehawk 2 1
cC
cF1
cK23605
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/17 12:02:39 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/db/dbmemops.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK38395
cPlib/db/dbmemops.c
cR2621ed07888462a5
cV2
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: DB
\***************************************************************/

#define _KOALAMUD_DBMEMOPS_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>
I 3
#include <sys/mman.h>
E 3

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"
I 9
#include "memory.h"
E 9
D 6
#include "dbinternal.h"
E 6
I 6
#include "lib/dbinternal.h"
E 6

/* This file contains various memory handling routines specific to the
 * database code. */

/* Map a database fs block on a page alignment boundry.  This function adds
 * the mapping to a table for tracking.  We will page align the starting block
D 3
 * and map at least enough blocks to include blockstart + len in the mapping */
E 3
I 3
 * and map at least enough blocks to include blockstart + len in the mapping
 *
 * FIXME: No checking is done to make sure that the block already exists in the
 * file.  
 */
E 3
void *mmapblockaligned(int dbfd, kdbfs_blockid_t blockstart,
						kdbfs_blockid_t len)
{
D 3
	return NULL;
E 3
I 3
	/* List iterator */
	dbmemstate_t *ms = dbstate.dbmap;
	off_t	foffset;
	size_t	offby;
	kdbfs_blockid_t numtomap = len;
	kdbfs_blockid_t blkstart = blockstart;

	/* First we need to figure out the offset into the file. */
	foffset = blockstart * BLOCKSIZE;

	/* Page align the starting point */
	if ((offby = foffset % dbstate.pagesize) != 0)
	{
		/* We are offset by one or more blocks.  Figure out the difference and
		 * add it to the maplength, then adjust the offset */
		numtomap += offby/BLOCKSIZE;
		foffset -= offby;
		blkstart -= offby/BLOCKSIZE;
	}

	/* Search for an existing mapping that meets our criteria */
	while (ms)
	{
		/* Does this block meet the request? */
		if ((blkstart == ms->mapstart && numtomap <= ms->maplen) ||
				(blkstart >= ms->mapstart &&
D 4
				 	(numtomap <= (ms->maplen - blkstart - ms->mapstart)))
				)
E 4
I 4
				 	((blkstart + numtomap) <= (ms->mapstart + ms->maplen))))
E 4
		{
			/* The block fits, increment the reference counter and return the
			 * pointer */
			ms->refcount++;
D 5
			return ms->chunkbase + (blkstart - ms->mapstart) * BLOCKSIZE;
E 5
I 5
			return ms->chunkbase + (blockstart - ms->mapstart) * BLOCKSIZE;
E 5
		}

		ms = ms->next;
	}

	/* No existing map was found, create a new one */
	{
		/* Allocate a memstate block */
D 8
		if ((ms = malloc(sizeof(dbmemstate_t))) == NULL)
E 8
I 8
		if ((ms = kmalloc(sizeof(dbmemstate_t), ALLOC_DATABASE)) == NULL)
E 8
		{
			logerr("Unable to allocate memory for mapping");
			return NULL;
		}
		/* Link the block into the block map */
		ms->next = dbstate.dbmap;
		dbstate.dbmap = ms;
		/* Fill it in */
		ms->fd = dbfd;
		ms->mapstart = blkstart;
		ms->maplen = numtomap;
		ms->refcount = 1;

		/* map it into memory */
		if ((ms->chunkbase = mmap(NULL, ms->maplen * BLOCKSIZE,
			PROT_READ | PROT_WRITE, MAP_SHARED, ms->fd,
			ms->mapstart * BLOCKSIZE)) == MAP_FAILED)
		{
			dbstate.dbmap = ms->next;
D 8
			free(ms);
E 8
I 8
			kmfree(ms, ALLOC_DATABASE);
E 8
			logerr("Unable to map database block");
			return NULL;
		}

I 7
		/* Keep track of the ammount mapped for reporting */
		dbstate.qmapped += ms->maplen * BLOCKSIZE;
E 7
	}

	return ms->chunkbase + offby;
E 3
}

D 3
/* Unmap the block entire block pointed to by blkaddr.  Tracking table
 * includes number of blocks in the mapping, so we don't need that to
 * correctly unmap */
void munmapblockaligned(void *blkaddr)
E 3
I 3
/* Unmap all mapped blocks with a reference count of 0 */
void unmapfreeblocks(void)
E 3
{
I 3
	/* List iterator */
	dbmemstate_t *ms = dbstate.dbmap;
	dbmemstate_t *msb = ms;
	dbmemstate_t *tofree;
	kdbfs_blockid_t freecount;

	/* Loop through the list */
	while (ms)
	{
		if (ms->refcount == 0)
		{
			tofree = ms;

			/* Count the number of blocks we free for reporting */
			freecount += tofree->maplen;

			/* This block is the list head */
			if (tofree == dbstate.dbmap)
			{
				dbstate.dbmap = tofree->next;
				msb = dbstate.dbmap;
				ms = dbstate.dbmap;
			}
			else
			{
				msb->next = ms->next;
				ms = ms->next;
			}

			/* At this point, the iterator and back pointer have been
			 * advanced.  All that remains is to unmap 'tofree' and free the
			 * state node */
			munmap(tofree->chunkbase, tofree->maplen * BLOCKSIZE);
I 7
			dbstate.qmapped -= tofree->maplen * BLOCKSIZE;
D 8
			free(tofree);
E 8
I 8
			kmfree(tofree, ALLOC_DATABASE);
E 8
E 7
		}
		else
		{
			/* This block is still being referenced */
			msb = ms;
			ms = ms->next;
		}
	}
}

/* mapfree
 * 	Release a block mapping
 * 		This does not actually unmap the data, it only decrements the
 * 		reference count.
 */
void mapfree(void *blkaddr)
{
	/* List iterator */
	dbmemstate_t *ms = dbstate.dbmap;

	/* Loop through the linked list of mappings and locate the block */
	while (ms)
	{
		/* Is the address in the blocks range */
		if (blkaddr >= ms->chunkbase &&
				blkaddr <= (ms->chunkbase + BLOCKSIZE * ms->maplen))
		{
			ms->refcount -= ms->refcount ? 1 : 0;
			return;
		}

		ms = ms->next;
	}
}

/* closemapfile
 *	Unmap all mappings to the file and close its file handle
 */
void closemapfile(int dbfd)
{
	/* List iterator */
	dbmemstate_t *ms = dbstate.dbmap;

	/* Set the refcount on all mappings from this fd to 0 */
	while (ms)
	{
		if (ms->fd == dbfd)
		{
			ms->refcount = 0;
		}
		ms = ms->next;
	}

	/* Unmap all mapped blocks */
	unmapfreeblocks();

	/* Close the file */
	close(dbfd);
E 3
}
E 2
I 1
E 1
