/* @(#) vm.h 1.3 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: VMLib
\***************************************************************/

#ifndef _KOALAMUD_VM_H
#define _KOALAMUD_VM_H "@(#) nitehawk@winghove.1ststep.net|include/vm.h|20000313060459|06043 @(#)"

/* Exported VM types */
typedef struct TAG_VMCONFIG_T
{
	char *vmdbpath;		/* Base path of DB */
	char *vmdbrootname;	/* DB Root name */
	char *vmext;		/* DB file extention */
} vmconfig_t;

/* Exported globals */
extern vmconfig_t vmconfig;

/* VM Errors */
typedef enum
{
	VMSUCCESS = 0,
	VMEOFFSET = 99, /* Offset by 100 to differentiate from koala errors */
	VMEMEM,
	VMBADSTATE,
	VMELAST,
} vmerr_t;

/* Vm State change functions */
int vmstartup(void);  // Call first
int vmlinkup(void);
int vmshutdown(void);

/* Error printing functions */
/* Return a pointer to a string describing the given error */
char * vmstrerr(vmerr_t err);


#endif
