h17982
s 00005/00000/00271
d D 1.18 00/11/05 19:26:43 nitehawk 19 18
c Add description to memstat
cC
cHparanor.1ststep.net
cK10446
cZ+00:00
e
s 00008/00000/00263
d D 1.17 00/11/04 21:28:17 nitehawk 18 17
c Add outputs to memstat for CMDTABLE and STRING alloc types
cC
cK58028
e
s 00000/00122/00263
d D 1.16 00/11/04 20:41:49 nitehawk 17 16
c remove load/unloadmod functions
cC
cK25212
e
s 00000/00000/00385
d D 1.15 00/11/04 19:31:47 nitehawk 16 15
c Rename: src/client/commandcontrol.c -> lib/basecommand/control.c
cK05833
cPlib/basecommand/control.c
e
s 00000/00361/00385
d D 1.14 00/11/04 19:07:45 nitehawk 15 14
c remove defunct command handlers
cC
cK55895
e
s 00368/00006/00378
d D 1.13 00/11/04 18:51:43 nitehawk 14 13
c Clone old command handlers into new prototypes which include
c argument list.
cC
cHwinghove.1ststep.net
cK59242
cZ-08:00
e
s 00004/00004/00380
d D 1.12 00/08/26 19:52:50 nitehawk 13 12
c convert all logging calls into logmsg
cC
cK42346
e
s 00020/00007/00364
d D 1.11 00/08/10 22:02:07 nitehawk 12 11
c Fix segfault when specifying single argument to
c reboot and shutdown
cC
cK39922
e
s 00123/00000/00248
d D 1.10 00/08/01 20:58:10 nitehawk 11 10
c Add do_loadmod and do_unloadmod
cC
cHlocalhost.1ststep.net
cK24018
cZ-07:00
e
s 00000/00000/00248
d D 1.9 00/03/07 11:48:10 nitehawk 10 9
c Turn on SCCS flag
cC
cK35389
cX0xa1
e
s 00004/00002/00244
d D 1.8 00/02/26 23:04:17 nitehawk 9 8
c uplinksendmessage needs messageid parameter
cC
cK62320
e
s 00028/00000/00218
d D 1.7 00/02/24 22:04:09 nitehawk 8 7
c Add memstat command handler
cK62008
e
s 00010/00004/00208
d D 1.6 00/02/23 23:41:59 nitehawk 7 6
c Convert straight memory calls to use wrapper functions
cC
cK36275
e
s 00000/00000/00212
d D 1.5 00/02/10 09:21:23 nitehawk 6 5
c Rename: src/commandcontrol.c -> src/client/commandcontrol.c
cC
cK00240
cPsrc/client/commandcontrol.c
e
s 00090/00002/00122
d D 1.4 00/02/04 20:14:41 nitehawk 5 4
c Added reboot command
cC
cK19815
e
s 00018/00003/00106
d D 1.3 00/02/01 12:24:26 nitehawk 4 3
c Can't send the shutdown message back to the player
cC
cK07885
e
s 00077/00000/00032
d D 1.2 00/02/01 11:54:32 nitehawk 3 2
c Added 'shutdown' command
cK44946
e
s 00032/00000/00000
d D 1.1 00/01/31 09:11:13 nitehawk 2 1
cC
cF1
cK56542
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/01/31 09:11:13 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/commandcontrol.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK37101
cPsrc/commandcontrol.c
cRf874487df2779860
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDINFO_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
I 3
#include "log.h"
E 3
#include "network.h"
#include "buffer.h"
#include "commands.h"
I 3
#include "uplinkprotocol.h"
I 4
#include "memory.h"
#include "llist.h"
I 11
#include "module.h"
I 14
#include "kparser.h"
E 14
E 11
E 4
E 3

/* Quit Command */
D 14
koalaerror do_quit(pdescriptor desc)
E 14
I 14
koalaerror do_quit(pdescriptor desc, argument *arglist[])
{
	char *quitmsg = "Thank you for trying KoalaMud\r\n";

	buffer_queue(desc, quitmsg, strlen(quitmsg));
	/* Make sure the buffer is emptied */
	buffer_sendbytes(desc, OUTRINGSIZE);

	desc->status = STATUS_CLOSE;

	return KESUCCESS;
}

/* Reboot command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
koalaerror do_reboot(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */
	if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_REBOOT;
		kmfree(line, ALLOC_TEMP);
		return KESUCCESS;
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_REBOOT, &msgdat,
						0);
				kmfree(line, ALLOC_TEMP);
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_REBOOT;
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* Shutdown command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
koalaerror do_shutdown(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */

	if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_SHUTDOWN;
		kmfree(line, ALLOC_TEMP);
		return KESUCCESS;
	}

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_SHUTDOWN, &msgdat,
						0);
				kmfree(line, ALLOC_TEMP);
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_SHUTDOWN;
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* Display memory status */
koalaerror do_memstat(pdescriptor desc, argument *arglist[])
{
	char buf[120];

I 19
	snprintf(buf, 120, "Current memory allocation (note, only the object
		counts are accurate.  The bytes remaining are\r\n
		not currently tracked precisely)\r\n");
	buffer_queue(desc, buf, strlen(buf));

E 19
	snprintf(buf, 120, "Generic memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_GENERIC].allocsize,
			memstate[ALLOC_GENERIC].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Database memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DATABASE].allocsize,
			memstate[ALLOC_DATABASE].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120, "Descriptor memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DESCRIPTOR].allocsize,
			memstate[ALLOC_DESCRIPTOR].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Temporary memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_TEMP].allocsize,
			memstate[ALLOC_TEMP].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"Linked List memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_LLIST].allocsize,
			memstate[ALLOC_LLIST].numobjects);
	buffer_queue(desc, buf, strlen(buf));
I 18
	snprintf(buf,120,"Command Table memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_CMDTABLE].allocsize,
			memstate[ALLOC_CMDTABLE].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"String memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_STRING].allocsize,
			memstate[ALLOC_STRING].numobjects);
	buffer_queue(desc, buf, strlen(buf));
E 18
	return KESUCCESS;
}
D 17

koalaerror do_loadmod(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	char buf[256];

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc < 2)
	{
		snprintf(buf, 256, "Huh?");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Unload the module */
	loadmodule(argv[0], argv[1], MODTYPE_GENERIC, desc);

	/* Free line buffer */
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

koalaerror do_unloadmod(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	char buf[256];

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc == 0)
	{
		snprintf(buf, 256, "Huh?");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Unload the module */
	unloadmodule(argv[0], desc);

	/* Free Line Buffer */
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}
E 17
D 15

/* Quit Command */
koalaerror do_oldquit(pdescriptor desc)
E 14
{
	char *quitmsg = "Thank you for trying KoalaMud\r\n";

	buffer_queue(desc, quitmsg, strlen(quitmsg));
	/* Make sure the buffer is emptied */
	buffer_sendbytes(desc, OUTRINGSIZE);

	desc->status = STATUS_CLOSE;
I 3

	return KESUCCESS;
}

/* Shutdown command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
D 14
koalaerror do_shutdown(pdescriptor desc)
E 14
I 14
koalaerror do_oldshutdown(pdescriptor desc)
E 14
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
I 4
	listnodeptr tmplist;
	pdescriptor tmpdesc;
E 4

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
D 7
		line = malloc(len);
E 7
I 7
		line = kmalloc(len, ALLOC_TEMP);
E 7
		if (!line)
		{
D 13
			logerr("Unable to allocate memory for line buffer");
E 13
I 13
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
E 13
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
D 7
			free(line);
E 7
I 7
			kmfree(line, ALLOC_TEMP);
E 7
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */
D 12
	if (argc == 0)
E 12
I 12

	if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc == 0)
E 12
	{
		// No arguments, just shutdown current node right now
D 5
		kstate.running = FALSE;
E 5
I 5
		kstate.running = DSTATE_SHUTDOWN;
I 7
		kmfree(line, ALLOC_TEMP);
E 7
E 5
		return KESUCCESS;
	}

D 12
	timer = atoi(argv[0]);
	destnode = (unsigned int)strtoul(argv[1], NULL, 10);

E 12
	if (destnode != 0)
	{
D 4
		msgdat.data = NULL;
		uplinksendmessage(desc, destnode, MSGTYPE_SHUTDOWN, &msgdat);
		return KESUCCESS;
E 4
I 4
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
D 9
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_SHUTDOWN, &msgdat);
E 9
I 9
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_SHUTDOWN, &msgdat,
						0);
E 9
I 7
				kmfree(line, ALLOC_TEMP);
E 7
				return KESUCCESS;
			}
		}
E 4
	}

	/* We don't handle the timer yet */
D 5
	kstate.running = FALSE;
E 5
I 5
	kstate.running = DSTATE_SHUTDOWN;
I 7
	kmfree(line, ALLOC_TEMP);
E 7

	return KESUCCESS;
}

/* Reboot command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
D 14
koalaerror do_reboot(pdescriptor desc)
E 14
I 14
koalaerror do_oldreboot(pdescriptor desc)
E 14
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
D 7
		line = malloc(len);
E 7
I 7
		line = kmalloc(len, ALLOC_TEMP);
E 7
		if (!line)
		{
D 13
			logerr("Unable to allocate memory for line buffer");
E 13
I 13
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
E 13
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
D 7
			free(line);
E 7
I 7
			kmfree(line, ALLOC_TEMP);
E 7
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */
	if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_REBOOT;
I 7
		kmfree(line, ALLOC_TEMP);
E 7
		return KESUCCESS;
	}
D 12

	timer = atoi(argv[0]);
	destnode = (unsigned int)strtoul(argv[1], NULL, 10);
E 12
I 12
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}
E 12

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
D 9
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_REBOOT, &msgdat);
E 9
I 9
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_REBOOT, &msgdat,
						0);
E 9
I 7
				kmfree(line, ALLOC_TEMP);
E 7
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_REBOOT;
I 7
	kmfree(line, ALLOC_TEMP);
E 7
E 5
E 3

	return KESUCCESS;
}
I 8

/* Display memory status */
D 14
koalaerror do_memstat(pdescriptor desc)
E 14
I 14
koalaerror do_oldmemstat(pdescriptor desc)
E 14
{
	char buf[120];

	snprintf(buf, 120, "Generic memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_GENERIC].allocsize,
			memstate[ALLOC_GENERIC].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Database memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DATABASE].allocsize,
			memstate[ALLOC_DATABASE].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120, "Descriptor memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DESCRIPTOR].allocsize,
			memstate[ALLOC_DESCRIPTOR].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Temporary memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_TEMP].allocsize,
			memstate[ALLOC_TEMP].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"Linked List memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_LLIST].allocsize,
			memstate[ALLOC_LLIST].numobjects);
	buffer_queue(desc, buf, strlen(buf));
I 11
	return KESUCCESS;
}

D 14
koalaerror do_loadmod(pdescriptor desc)
E 14
I 14
koalaerror do_oldloadmod(pdescriptor desc)
E 14
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	char buf[256];

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
D 13
			logerr("Unable to allocate memory for line buffer");
E 13
I 13
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
E 13
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc < 2)
	{
		snprintf(buf, 256, "Huh?");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Unload the module */
	loadmodule(argv[0], argv[1], MODTYPE_GENERIC, desc);

	/* Free line buffer */
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

D 14
koalaerror do_unloadmod(pdescriptor desc)
E 14
I 14
koalaerror do_oldunloadmod(pdescriptor desc)
E 14
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	char buf[256];

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
D 13
			logerr("Unable to allocate memory for line buffer");
E 13
I 13
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
E 13
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc == 0)
	{
		snprintf(buf, 256, "Huh?");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Unload the module */
	unloadmodule(argv[0], desc);

	/* Free Line Buffer */
	kmfree(line, ALLOC_TEMP);

E 11
	return KESUCCESS;
}
E 15
E 8
E 2
I 1
E 1
