h32489
s 00008/00016/00106
d D 1.11 00/08/22 20:17:48 nitehawk 12 11
c Converting to new logmsg
cC
cHlocalhost.1ststep.net
cK14884
cZ-07:00
e
s 00000/00000/00122
d D 1.10 00/03/07 11:48:13 nitehawk 11 10
c Turn on SCCS flag
cC
cK12598
cX0xa1
e
s 00000/00000/00122
d D 1.9 00/02/12 10:06:33 nitehawk 10 9
c Rename: lib/signal.c -> lib/koala/signal.c
cC
cK15549
cPlib/koala/signal.c
e
s 00000/00000/00122
d D 1.8 00/02/07 23:57:22 nitehawk 9 8
c Rename: src/signal.c -> lib/signal.c
cC
cK07003
cPlib/signal.c
e
s 00012/00006/00110
d D 1.7 00/02/05 18:58:28 nitehawk 8 7
c Fix siginfo output
cC
cHwinghove.1ststep.net
cK32163
cZ-08:00
e
s 00001/00001/00115
d D 1.6 00/02/06 00:18:35 nitehawk 7 6
c SIGINFO not portable, now SIGUSR1
cC
cHparanor.1ststep.net
cK14988
cZ+00:00
e
s 00001/00000/00115
d D 1.5 00/02/05 16:11:38 nitehawk 6 5
c Trap SIGTERM to preform soft shutdown
cC
cK14989
e
s 00086/00002/00029
d D 1.4 00/02/05 14:51:59 nitehawk 5 4
c Added reboot sig handler for SIGHUP
c Added info sig handler for SIGINFO
cK12362
e
s 00001/00001/00030
d D 1.3 00/02/04 20:14:52 nitehawk 4 3
c Change sig handler to use DSTATE_SHUTDOWN instead of FALSE
cC
cK48678
e
s 00001/00006/00030
d D 1.2 00/02/01 20:42:34 nitehawk 3 2
c signal.h --> sig.h
cC
cK47857
e
s 00036/00000/00000
d D 1.1 00/02/01 20:09:48 nitehawk 2 1
cF1
cK54492
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/01 20:09:48 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/signal.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK10752
cPsrc/signal.c
cR4f086c216a5502a3
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: SIGNAL
\***************************************************************/

#define _KOALAMUD_SIGNAL_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
D 3
#include "daemon.h"
#include "network.h"
E 3
#include "log.h"
D 3

#include "zone.h"
#include "hub.h"
#include "client.h"
E 3
I 3
#include "sig.h"
I 5
#include "memory.h"
#include "llist.h"
E 5
E 3

D 5
void siginthandler(int sig)
E 5
I 5
/* Shutdown system */
void sigshutdown(int sig)
E 5
{
D 4
	kstate.running = FALSE;
E 4
I 4
	kstate.running = DSTATE_SHUTDOWN;
E 4
}

I 5
/* Reboot System */
void sigreboot(int sig)
{
	kstate.running = DSTATE_REBOOT;
}

/* Print out process information */
void siginfo(int sig)
{
	listnodeptr desclist;
	pdescriptor desc;
	int numhub, numzone, numcli, numlisten, numplayer;
D 12
	char buf[256];
E 12

	/* Initialize counters */
	numhub = numzone = numcli = numlisten = numplayer = 0;

	/* get list pointer */
	desclist = getdescriptorlist();

	/* loop through the list and log status */
	for (;desclist; desclist = listnextnode(desclist))
	{
		desc = desclist->data.desc;

		switch(desc->type)
		{
			case DESCRIPTOR_HUBSRV:
				numhub++;
D 12
				snprintf(buf, sizeof(buf),
E 12
I 12
				logmsg(LOGINFO,
E 12
D 8
						"Hub: nodeid=%d, Socket=%d, %d bytes buffered",
E 8
I 8
						"Hub: nodeid=%d, Socket=%d, %d bytes buffered,"
						" Current MessageID=%d",
E 8
						desc->nodeid, desc->socket,
D 8
						abs(desc->buffer.intail - desc->buffer.inhead));
E 8
I 8
						abs(desc->buffer.intail - desc->buffer.inhead),
						desc->data.hubsrv->curmsg.messageid);
E 8
D 12
				logmsg(buf);
E 12
				break;
I 12

E 12
			case DESCRIPTOR_CLIENTSRV:
				numcli++;
D 12
				snprintf(buf, sizeof(buf),
E 12
I 12
				logmsg(LOGINFO,
E 12
D 8
						"Client: nodeid=%d, Socket=%d, %d bytes buffered",
E 8
I 8
						"Client: nodeid=%d, Socket=%d, %d bytes buffered,"
						" Current MessageID=%d",
E 8
						desc->nodeid, desc->socket,
D 8
						abs(desc->buffer.intail - desc->buffer.inhead));
E 8
I 8
						abs(desc->buffer.intail - desc->buffer.inhead),
						desc->data.clientsrv->curmsg.messageid);
E 8
D 12
				logmsg(buf);
E 12
				break;
			case DESCRIPTOR_ZONESRV:
				numzone++;
D 12
				snprintf(buf, sizeof(buf),
E 12
I 12
				logmsg(LOGINFO,
E 12
D 8
						"Hub: nodeid=%d, Socket=%d, %d bytes buffered",
E 8
I 8
						"Zone: nodeid=%d, Socket=%d, %d bytes buffered,"
						" Current MessageID=%d",
E 8
						desc->nodeid, desc->socket,
D 8
						abs(desc->buffer.intail - desc->buffer.inhead));
E 8
I 8
						abs(desc->buffer.intail - desc->buffer.inhead),
						desc->data.zonesrv->curmsg.messageid);
E 8
D 12
				logmsg(buf);
E 12
				break;
			case DESCRIPTOR_PLAYER:
				numplayer++;
D 12
				snprintf(buf, sizeof(buf),
E 12
I 12
				logmsg(LOGINFO,
E 12
						"Player: Name='%s', Socket=%d, %d bytes buffered",
						desc->data.character->name, desc->socket,
						abs(desc->buffer.intail - desc->buffer.inhead));
D 12
				logmsg(buf);
E 12
				break;
			case DESCRIPTOR_LISTEN:
				numlisten++;
D 12
				snprintf(buf, sizeof(buf),
E 12
I 12
				logmsg(LOGINFO,
E 12
						"Listen: Socket=%d",
						desc->socket);
D 12
				logmsg(buf);
E 12
				break;
			default:
		}
	}

	/* Print out a summary line */
D 12
	snprintf(buf, sizeof(buf), "uplinks: %d hub, %d client, %d zone",
E 12
I 12
	logmsg(LOGINFO, "uplinks: %d hub, %d client, %d zone",
E 12
			numhub, numcli, numzone);
D 12
	logmsg(buf);
	snprintf(buf, sizeof(buf), "%d Listen, %d players",
			numlisten, numplayer);
	logmsg(buf);
E 12
I 12
	logmsg(LOGINFO, "%d Listen, %d players", numlisten, numplayer);
E 12
}

E 5
/* Use signal syscall to setup signal handling */
koalaerror initsighandlers(void)
{
D 5
	signal(SIGINT, siginthandler);
E 5
I 5
	signal(SIGINT, sigshutdown);
I 6
	signal(SIGTERM, sigshutdown);
E 6
	signal(SIGHUP, sigreboot);
E 5
	signal(SIGPIPE, SIG_IGN);
I 5
D 7
	signal(SIGINFO, siginfo);
E 7
I 7
	signal(SIGUSR1, siginfo);
E 7
E 5

	return KESUCCESS;
}
E 2
I 1
E 1
