/***************************************************************************
                          tabs.cpp  -  description
                             -------------------
    begin                : Die Mai 20 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabs.h"
#include "krenameimpl.h"

// Qt includes
#include <qlayout.h>
#include <qsizepolicy.h> 
#include <qtabwidget.h>

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <kstartupinfo.h>

tabs::tabs(KRenameImpl* impl, QRect r, QWidget *parent, const char *name )
    : QDialog(parent,name)
{
    setIcon( BarIcon( "krename" ) );

    QVBoxLayout* layout = new QVBoxLayout( this, 6, 6 );
    QHBoxLayout* buttons = new QHBoxLayout( 0, 6, 6 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Expanding );
    
    tab = new QTabWidget( this );
    finishButton = new KPushButton( i18n("&Finish"), this );
    finishButton->setIconSet( SmallIconSet( "finish" ) );
    finishButton->setDefault( true );
    cancelButton = new KPushButton( i18n("&Cancel"), this );
    cancelButton->setIconSet( SmallIconSet( "button_cancel" ) );
    
    buttons->addItem( spacer );
    buttons->addWidget( finishButton );
    buttons->addWidget( cancelButton );
    
    layout->addWidget( tab );
    layout->addLayout( buttons );
    layout->setStretchFactor( tab, 2 );

    menuBar = new KMenuBar( this );
    layout->setMenuBar( menuBar );
    
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( close() ) );

    if( impl ) {
        krename = impl;
        connect( krename, SIGNAL( pageDone( QWidget*, const QString & ) ), this, SLOT( slotAddPage( QWidget*, const QString & ) ) );
        krename->changeParent( this, menuBar, finishButton, r );
    } else {
        krename = new KRenameImpl( this, menuBar, finishButton );
        connect( krename, SIGNAL( pageDone( QWidget*, const QString & ) ), this, SLOT( slotAddPage( QWidget*, const QString & ) ) );
    }
    
    connect( krename, SIGNAL( showPage( int ) ), this, SLOT( slotShowPage( int ) ) );
    connect( krename, SIGNAL( enableFinish( bool ) ), this, SLOT( slotEnableFinish( bool ) ) );
    if( !impl )
        krename->setup();
    
    krename->setWizardMode( false );

    // Tell KStartupInfo that KRename has been loaded completly
    KStartupInfoId id;
    id.initId( kapp->startupId() );
    KStartupInfo::sendFinish( id );
}

tabs::~tabs()
{
}

void tabs::slotAddPage( QWidget* page, const QString & title )
{
    tab->addTab( page, title );
}

void tabs::slotShowPage( int page )
{
    tab->setCurrentPage( page - 1 );
}

void tabs::slotEnableFinish( bool b )
{
    finishButton->setEnabled( b );
}

void tabs::keyPressEvent( QKeyEvent *e )
{
    // ESC should not close KRename
    if( e->key() == Qt::Key_Escape )
        e->accept();
    else
        e->ignore();
}
