/***************************************************************************
                                    elogeventthreadsubmit.h
                             -------------------
    begin                : Feb 09 2004
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ELOGEVENTTHREADSUBMIT_H
#define ELOGEVENTTHREADSUBMIT_H

#include <qthread.h>
#include <kstdebug.h>
#include "elogthread.h"
#include "elog.h"

class ElogEventThreadSubmit : public ElogThread {
  public:
    ElogEventThreadSubmit(KstELOG* pELOG,
                          bool bIncludeCapture,
                          bool bIncludeConfiguration,
                          bool bIncludeDebugInfo,
                          QByteArray* pByteArrayCapture,
                          QString strMessage,
                          QString strUserName,
                          QString strUserPassword,
                          QString strWritePassword,
                          QString strLogbook,
                          QString strAttributes,
                          bool bSubmitAsHTML,
                          bool bSuppressEmail);

virtual ~ElogEventThreadSubmit();
    virtual void run();
    
  protected:
    virtual void doTransmit( int sock );
    virtual bool doResponseError( const char* response );

  private:
    QByteArray _byteArrayCapture;
    QString _strMessage;
    QString _strUserName;
    QString _strUserPassword;
    QString _strWritePassword;
    QString _strLogbook;
    QString _strAttributes;
    bool    _bSubmitAsHTML;
    bool    _bSuppressEmail;
    bool    _bIncludeCapture;
    bool    _bIncludeConfiguration;
    bool    _bIncludeDebugInfo;
};

#endif

// vim: ts=2 sw=2 et
