// =============================================================================
//
//      --- kvi_lineeditdialog_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <kdeversion.h>
#if KDE_IS_VERSION(3,2,0)
	#include <kinputdialog.h>
#else
	#include <klineeditdlg.h>
#endif

#include "kvi_lineeditdialog_kde.h"

KviLineEditDialog::KviLineEditDialog()
{
	// Nothing here
}

KviLineEditDialog::~KviLineEditDialog()
{
	// Nothing here
}

QString KviLineEditDialog::getText(
	const QString &caption, const QString &text, const QString &value, bool *ok, QWidget *parent)
{
#if KDE_IS_VERSION(3,2,0)
	return KInputDialog::getText(caption, text, value, ok, parent);
#else
	return KLineEditDlg::getText(caption, text, value, ok, parent);
#endif
}
