#ifndef _KVI_CONFIG_H_INCLUDED_
#define _KVI_CONFIG_H_INCLUDED_

// =============================================================================
//
//      --- kvi_config.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qdict.h>

#include "kvi_string.h"

class QColor;
class QFont;
class QRect;
class QString;

typedef QDict<KviStr> KviStrDict;

class KviConfig
{
public:
	KviConfig(const char *filename);
	~KviConfig();
private:
	QDict<KviStrDict> *m_pDict;
	KviStr m_szFileName;
	  bool m_bDirty;
	KviStr m_szStrBuffer;
	KviStr m_szGroup;
private:
	bool load();
	bool save();
	KviStrDict *getCurrentGroup();
public:
	void clear();
	bool sync();
	const char *group();
	void setGroup(const char *szGroup);

	void clearGroup(const char *szGroup);
	void   clearKey(const char *szKey);

	bool hasKey(const char *szKey);

	void getContentsString(KviStr &buffer);

	unsigned short int  readUShortEntry(const char *szKey, unsigned short int usDefault);
	unsigned       int    readUIntEntry(const char *szKey, unsigned int iDefault);
	               int     readIntEntry(const char *szKey, int iDefault);
	unsigned      char   readUCharEntry(const char *szKey, unsigned char iDefault);
	const         char*       readEntry(const char *szKey, const char *szDefault = 0);
	              char    readCharEntry(const char *szKey, char iDefault);
	              bool    readBoolEntry(const char *szKey, bool bTrue);
	QColor readColorEntry(const char *szKey, const QColor &clr);
	QFont   readFontEntry(const char *szKey,        QFont &fnt);
	QRect   readRectEntry(const char *szKey, const  QRect &rct);
	void writeEntry(const char *szKey,               bool  bTrue);
	void writeEntry(const char *szKey,               char  iValue);
	void writeEntry(const char *szKey, const         char *szValue);
	void writeEntry(const char *szKey, unsigned      char  iValue);
	void writeEntry(const char *szKey,                int  iValue);
	void writeEntry(const char *szKey, unsigned       int  iValue);
	void writeEntry(const char *szKey, unsigned short int  usValue);
	void writeEntry(const char *szKey, const  QRect &rct);
	void writeEntry(const char *szKey,        QFont &fnt);
	void writeEntry(const char *szKey, const QColor &clr);

	static void getFontProperties(KviStr &buffer, QFont *fnt);
	static void setFontProperties(KviStr &str, QFont *fnt);

	static QFont getFixedFont();
private:
	static bool getFont(QFont &, QString desired);
};

#endif // _KVI_CONFIG_H_INCLUDED_
