#ifndef _KVI_DNS_H_INCLUDED_
#define _KVI_DNS_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dns.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qdns.h>

class KviDns;

typedef QValueList<QHostAddress> KviIpAddresses;

typedef struct KviDnsData
{
	KviDns         *parent;
	QString        hostname;
	KviIpAddresses addresses;
	bool           bIPv6;
	int            iError;
};

class KviDns : public QDns
{
	Q_OBJECT
public:
	KviDns();
	~KviDns();

	bool resolve(const char *hostname, bool bIPv6 = false);
	bool abort();
	/**
	 * This method can be used after the finished() signal has been triggered
	 * and no new lookup has been started. It sets the dnsStruct to zero
	 * without deleting it and returns the pointer to it.
	 * In this way the user class can take control over the data structure.
	*/
	KviDnsData *releaseData();
signals:
	void finished(KviDnsData *);
protected slots:
	void slotProcessResults();
private:
	KviDnsData *m_dnsData;

	void clearData();
};

#endif // _KVI_DNS_H_INCLUDED_
