#ifndef _KVI_LOCALE_H_INCLUDED_
#define _KVI_LOCALE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_locale.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//                 2004 Robin Verduijn (robin@debian.org)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_settings.h"

#ifndef _KVI_LOCALE_CPP_
	#ifdef COMPILE_LOCALE_STUFF
		#include <libintl.h>
		#define _i18n_(__text__) gettext(__text__)
	#else
		#define _i18n_(__text__) __text__
	#endif
	// Dummy macro used only to mark strings for externalization:
	#define _i19n_(__text__) __text__

	class KviApplication;

	extern bool kvi_initLocale(KviApplication *app);
	extern void kvi_destroyLocale(KviApplication *app);
	extern char *kvi_getLocaleName();

#else // _KVI_LOCALE_CPP_
	#ifdef COMPILE_LOCALE_STUFF
		#include <qtranslator.h>
		class QString;

		class KviTranslator : public QTranslator
		{
			Q_OBJECT
			public:
				KviTranslator(QObject *parent, const char *name);
				~KviTranslator();
			public:
				virtual QString find(const char *scope, const char *message) const;
		};
	#endif
#endif // _KVI_LOCALE_CPP_

#endif // _KVI_LOCALE_H_INCLUDED_
