// =============================================================================
//
//      --- kvi_imagebutton.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviImageButton"

#include "kvi_imagebutton.h"
#include "kvi_imagefiledialog.h"
#include "kvi_locale.h"

KviImageButton::KviImageButton(QWidget *parent, const char *szImagePath, QPixmap *cachedPixmap)
	: KviPushButton(parent)
{
	connect(this, SIGNAL(clicked()), this, SLOT(slot_buttonClicked()));
	m_szImagePath = "";
	if( !szImagePath || !(*szImagePath) )
		return;
	if( cachedPixmap ) {
		if( !cachedPixmap->isNull() ) {
			m_szImagePath = szImagePath;
			setPixmap(*cachedPixmap);
		}
	} else tryLoadImage(szImagePath);
}

KviImageButton::~KviImageButton()
{
	// Nothing here
}

void KviImageButton::slot_buttonClicked()
{
	KviImageFileDialog aDlg(m_szImagePath.hasData() ? _CHAR_2_QSTRING(m_szImagePath.ptr()) : QString::null, "*");
	if( aDlg.exec() ) {
		KviStr szPath(aDlg.selectedFile());
		if( szPath.hasData() ) tryLoadImage(szPath.ptr());
	}
}

void KviImageButton::tryLoadImage(const char *szImagePath)
{
	QPixmap pm(szImagePath);
	if( !pm.isNull() ) {
		m_szImagePath = szImagePath;
		setPixmap(pm);
		return;
	}
	debug(_i18n_("Could not load the image %s\nInvalid image format or permission denied"), szImagePath);
}

const char *KviImageButton::getSelectedImagePath()
{
	return m_szImagePath.ptr();
}

#include "m_kvi_imagebutton.moc"
