// =============================================================================
//
//      --- kvi_transparentwidget.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviTransparentWidget"

#include <qpainter.h>
#include <qpixmap.h>

#include "kvi_transparentwidget.h"

KviTransparentWidget::KviTransparentWidget(QWidget *parent, const char *name)
	: QWidget(parent, name ? name : "transparent_widget")
{
	setMinimumSize(QSize(1, 1)); // No minimum size in fact, just notify Qt
	setBackgroundMode(NoBackground);
}

KviTransparentWidget::~KviTransparentWidget()
{
	// Nothing here
}

void KviTransparentWidget::paintEvent(QPaintEvent *e)
{
	if( !parent() ) {
		QWidget::paintEvent(e);
		return;
	}
	QPainter pa(this);
	QColorGroup cg = colorGroup();
	const QPixmap *pix = ((QWidget *) parent())->backgroundPixmap();
	if( pix ) {
		if( !pix->isNull() ) {
			pa.drawTiledPixmap(rect(), *pix, QPoint(-x(), -y()));
		} else pix = 0;
	}
	if( !pix ) {
		pa.fillRect(rect(), cg.button());
	}
}

QSizePolicy KviTransparentWidget::sizePolicy()
{
	return QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}

#include "m_kvi_transparentwidget.moc"
