#ifndef _KVI_DCC_MANAGER_H_INCLUDED_
#define _KVI_DCC_MANAGER_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_manager.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qobject.h>

#include "kvi_dcc_send.h"
#include "kvi_string.h"

class KviFrame;
class KviDccChat;
class KviIrcUser;

typedef struct KviDccRequest
{
	KviStr         szType;
	KviStr         szParam;
	KviStr         szAddress;
	KviStr         szPort;
	KviStr         szLast;
	KviStr         szGarbage;
	KviStr         szOriginalRequest;
	unsigned short uPort;
	unsigned long  uAddress;
};

class KviDccManager : public QObject
{
	Q_OBJECT
public:
	KviDccManager(KviFrame *frame);
	~KviDccManager();

	void handleDccRequest(KviIrcUser &source, KviDccRequest *dcc);

	void handleDccChat  (KviIrcUser &source, unsigned long addr, unsigned short port);
	void handleDccVoice (KviIrcUser &source, unsigned long addr, unsigned short port);
	void handleDccSend  (KviIrcUser &source, KviStr &filename, unsigned long len, unsigned long addr, unsigned short port);
	void handleDccAccept(KviIrcUser &source, KviStr &filename, unsigned short port, unsigned long uResumePos);
	void handleDccResume(KviIrcUser &source, KviStr &filename, unsigned short port, unsigned long uResumePos);

	KviDccChat *requestDccChat(const char *nick, const char *userandhost = 0);
	void requestDccVoice(const char *nick);
	void requestDccSend(const char *nick, const char *filename);

	unsigned short int getDccSendListenPort();
public slots:
	void acceptDccChat (const char *nick, const char *name, const char *host, unsigned long addr, unsigned short port);
	void acceptDccVoice(const char *nick, const char *name, const char *host, unsigned long addr, unsigned short port);
	void acceptDccSend             (KviDccSendRequestData *);
	void dccAcceptFileRequest      (KviDccSendRequestData *);
	void dccSendFileRequest        (KviDccSendRequestData *);
	void dccSendResumeSelectionDone(KviDccSendRequestData *);
protected:
	virtual bool event(QEvent *);

	KviFrame *m_pFrm;
};

#endif // _KVI_DCC_MANAGER_H_INCLUDED_
