// =============================================================================
//
//      --- kvi_dcc_sendresumemessagebox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDccSendResumeMessageBox"

#include "kvi_application.h"
#include "kvi_dcc_manager.h"
#include "kvi_dcc_send_event.h"
#include "kvi_dcc_sendresumemessagebox.h"
#include "kvi_fileutils.h"
#include "kvi_frame.h"
#include "kvi_locale.h"

KviDccSendResumeMessageBox::KviDccSendResumeMessageBox(KviFrame *parent, KviDccSendRequestData *data)
	: KviMessageBox(
		_CHAR_2_QSTRING(_i18n_("DCC Send Request")),
		_CHAR_2_QSTRING(""),
		NoIcon,
		Yes | Escape,
		No  | Default,
		Cancel,
		parent, 0, false
	  )
{
	m_pData = data;

	setButtonText(Yes,    _i18n_("&Rename"));
	setButtonText(No,     _i18n_("Re&sume"));
	setButtonText(Cancel, _i18n_("&Overwrite"));

	KviStr tmp(KviStr::Format,
		_i18n_(
			"The file %s already exists,\n"\
			"and is smaller than the incoming file.\n"\
			"It could be from a previous failed DCC transfer.\n"\
			"Do you want to resume the previous operation,\n"\
			"overwrite the existing file with the incoming file,\n"\
			"or rename the incoming file?"
		),
		data->filePath.ptr()
	);
	setText(_CHAR_2_QSTRING(tmp.ptr()));
}

KviDccSendResumeMessageBox::~KviDccSendResumeMessageBox()
{
	if( m_pData ) {
		delete m_pData;
		m_pData = 0;
	}
}

void KviDccSendResumeMessageBox::done(int result)
{
	KviMessageBox::done(result);
	if( !m_pData ) return;

	if( result == Yes ) { // Resume
		while( kvi_fileExists(m_pData->filePath.ptr()) )
			m_pData->filePath.append(".rename");
		m_pData->resumeValue = 0;
	} else if( result == Cancel ) // Overwrite
		m_pData->resumeValue = 0;
	// Otherwise resume; the file position is already set
	KviDccSendEvent *ev = new KviDccSendEvent(m_pData);
	KviApplication::postEvent(m_pData->parent, ev);
	m_pData = 0;
}

#include "m_kvi_dcc_sendresumemessagebox.moc"
