#ifndef _KVI_HELPWINDOW_H_INCLUDED_
#define _KVI_HELPWINDOW_H_INCLUDED_

// =============================================================================
//
//      --- kvi_helpwindow.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

class KviFrame;
class KviProcess;
class KviTextBrowser;

class KviHelpWindow : public QWidget
{
	Q_OBJECT
public:
	KviHelpWindow(KviFrame *pFrm, QWidget *parent = 0, const char *name = 0);
	~KviHelpWindow();
public:
	int             m_backButton;
	int             m_closeButton;
	int             m_copyButton;
	int             m_forwardButton;
	int             m_homeButton;
	int             m_inputField;
	int             m_searchButton;
	KviTextBrowser *m_pBrowser;
	KviToolBar     *m_pToolBar;
	KviFrame       *m_pFrame;
	KviProcess     *m_pSearchJob;
public:
	void setDocument(const char *topic);
	void doExactSearchForString(const char *str);
public slots:
	void showIndex();
	void backwardAvailable(bool bAvailable);
	void  forwardAvailable(bool bAvailable);
	void reloadDocument();
	void resetStyleSheet();
	void doExactSearch();
	void copyToClipboard();
	void searchJobTerminated(KviProcess *proc);
protected:
	void createBrowser();
	virtual void resizeEvent(QResizeEvent *);
};

#endif // _KVI_HELPWINDOW_H_INCLUDED_
