#ifndef _KVI_MODEEDITOR_H_INCLUDED_
#define _KVI_MODEEDITOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_modeeditor.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

#include "kvi_string.h"

class QCheckBox;

class KviLineEdit;
class KviPushButton;

typedef struct KviModeDescriptionEntry
{
	      char  flag;
	const char *description;
};

class KviModeEditor : public QFrame
{
	Q_OBJECT
public:
	KviModeEditor(QWidget *parent);
	~KviModeEditor();
protected:
	static KviModeDescriptionEntry modeTable[6];
	QCheckBox     *m_pCheck[6];
	bool           m_bInitState[6];
	KviPushButton *m_pCommit;
	QCheckBox     *m_pLimitCheck;
	KviLineEdit   *m_pLimitEdit;
	QCheckBox     *m_pKeyCheck;
	KviLineEdit   *m_pKeyEdit;
	KviStr         m_szInitLimit;
	KviStr         m_szInitKey;
public:
	void doEdit(KviStr &flags, KviStr &limit, KviStr &key, QObject *receiver, const char *slot);
	void setCanCommit(bool bCanCommit);
protected slots:
	void commitChanges();
	void cancel();
signals:
	void modeChanged(const char *newMode, const char *additionalModeChange);
};

#endif // _KVI_MODEEDITOR_H_INCLUDED_
