#ifndef _KVI_RAWEVENT_H_INCLUDED_
#define _KVI_RAWEVENT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_rawevent.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qasciidict.h>
#include <qptrlist.h>

#include "kvi_string.h"

typedef struct KviRawEventStruct
{
	KviStr szSource;
	KviStr szBuffer;
} KviRawEvent;

typedef QPtrList<KviRawEvent>  KviRawEventList;
typedef QPtrList<KviRawEvent> *KviRawEventListPtr;

class KviRawEventManager
{
public:
	KviRawEventManager();
	~KviRawEventManager();
private:
	KviRawEventListPtr m_numericEvents[1000];

	QAsciiDict<KviRawEventList> *m_pLiteralEventsDict;
public:
	KviRawEventListPtr numericEvent(int i);
	QAsciiDict<KviRawEventList> *literalEventsDict();

	void cleanup();
	void addHandler(const char *command, const char *source, const char *buffer);
	bool save(const char *filename);
	bool load(const char *filename, KviStr &error);

	inline QPtrList<KviRawEvent> *KviRawEventManager::numericHandlerFor(unsigned int nCommand, const char *szCommand)
	{
		return ((nCommand < 1000) ? m_numericEvents[nCommand] : literalHandlerFor(szCommand));
	}

	inline QPtrList<KviRawEvent> *literalHandlerFor(const char *szCommand)
	{
		return (m_pLiteralEventsDict ? (QPtrList<KviRawEvent> *) m_pLiteralEventsDict->find(szCommand) : 0);
	}
};

#endif // _KVI_RAWEVENT_H_INCLUDED_
